/*
 * Copyright (c) 2002 JSON.org
 * Copyright 2018-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * The Software shall be used for Good, not Evil.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.json.me;

import java.io.IOException;
import java.io.Writer;

/**
 * A simple StringBuffer-based implementation of StringWriter
 *
 * @deprecated this class was for internal use and is not used anymore.
 */
@Deprecated
public class StringWriter extends Writer {

	final private StringBuffer buf;

	public StringWriter() {
		super();
		buf = new StringBuffer();
	}

	public StringWriter(int initialSize) {
		super();
		buf = new StringBuffer(initialSize);
	}

	@Override
	public void write(char[] cbuf, int off, int len) throws IOException {
		buf.append(cbuf, off, len);
	}

	@Override
	public void write(String str) throws IOException {
		buf.append(str);
	}

	@Override
	public void write(String str, int off, int len) throws IOException {
		buf.append(str.substring(off, len));
	}

	@Override
	public void flush() throws IOException {
	}

	@Override
	public void close() throws IOException {
	}
}
