/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.tool.addon.util;

/**
 * Logging utility class.
 */
public final class Message {
	/** Message priority of "error". */
	public static final int MSG_ERR = 0;

	/** Message priority of "warning". */
	public static final int MSG_WARN = 1;

	/** Message priority of "information". */
	public static final int MSG_INFO = 2;

	/** Message priority of "verbose". */
	public static final int MSG_VERBOSE = 3;

	/** Message priority of "debug". */
	public static final int MSG_DEBUG = 4;

	private static MessageLogger defaultLogger = new DefaultMessageLogger(Message.MSG_INFO);

	/**
	 * Returns the current default logger.
	 *
	 * @return the current default logger; is never <code>null</code>.
	 */
	public static MessageLogger getDefaultLogger() {
		return defaultLogger;
	}

	/**
	 * Change the default logger used when no other logger is currently configured
	 *
	 * @param logger
	 *            the new default logger, must not be <code>null</code>
	 */
	public static void setDefaultLogger(MessageLogger logger) {
		defaultLogger = logger;
	}

	private static MessageLogger getLogger() {
		return defaultLogger;
	}

	public static void debug(String msg) {
		getLogger().debug(msg);
	}

	public static void verbose(String msg) {
		getLogger().verbose(msg);
	}

	public static void info(String msg) {
		getLogger().info(msg);
	}

	public static void warn(String msg) {
		getLogger().warn(msg);
	}

	public static void error(String msg) {
		getLogger().error(msg);
	}

	public static void log(int logLevel, String msg) {
		switch (logLevel) {
		case MSG_DEBUG:
			debug(msg);
			break;
		case MSG_VERBOSE:
			verbose(msg);
			break;
		case MSG_INFO:
			info(msg);
			break;
		case MSG_WARN:
			warn(msg);
			break;
		case MSG_ERR:
			error(msg);
			break;
		default:
			throw new IllegalArgumentException("Unknown log level " + logLevel);
		}
	}

	private Message() {
	}
}
