/*
 * Java
 *
 * Copyright 2014-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.websocket.http;

/**
 * HTTP header field as described by RFC 2616, section 6.2. Response Header Fields.
 * 
 * 
 * 
 */
public class Header {

	private static final char SEPARATOR = ':';

	private final String name;
	private final String value; // TODO there may be several values

	/**
	 * @param line
	 *            the header field in text format with terminating CRLF
	 */
	Header(String line) {
		int indexOfSeparator = line.indexOf(SEPARATOR);
		this.name = line.substring(0, indexOfSeparator);
		this.value = line.substring(indexOfSeparator + 2, line.length() - 2);
		// length - 2 to eliminate "\r\n" at the end of the line
	}

	/**
	 * @return the name of the header field
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the value of the header field
	 */
	public String getValue() {
		return value;
	}

	@Override
	public String toString() {
		return "HeaderField [name=" + name + ", value=" + value + "]";
	}

}
