/*
 * Java
 *
 * Copyright 2010-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.event;

import ej.microui.MicroUIException;

/**
 * MicroUI features int-based events, allowing for a rich event mechanism compatible with scare resources. This class
 * provides {@link EventGenerator} classes with event constants and helper methods to build and analyse events. <br>
 * <p>
 * An event has a type, a 8-bit figure that forms the most significant byte of the int-event, followed by 8-bits which
 * is the generator identifier quantity, and followed by 16-bit of data.<br>
 * <p>
 * event : type (8-bit) + generatorId (8-bit) + data (16-bit)<br>
 * <p>
 * The very first 16 types [0x00..0x0f], some of which are defined by constants in {@link EventGenerator} subclasses,
 * are MicroUI reserved. An application may create as many as 240 different kind of events.
 *
 * @see EventGenerator
 */
public class Event {

	/**
	 * Forbidden constructor: cannot instantiate an event object.
	 */
	private Event() {
	}

	/**
	 * Builds an event from a given type, an eventGenerator and data.
	 * <p>
	 * <code>type</code> and <code>data</code> must respect the format (respectively 0x0 to 0xff and 0x0 to 0xffff). No
	 * check is performed at runtime, only a crop is performed.
	 *
	 * @param type
	 *            the type of the event to build
	 * @param gen
	 *            the generator associated with the event
	 * @param data
	 *            the data of the event to build
	 * @return the event as an <code>int</code>
	 */
	public static int buildEvent(int type, EventGenerator gen, int data) {
		throw new RuntimeException();
	}

	/**
	 * Returns the type of an event.
	 *
	 * @param event
	 *            an event
	 * @return event's type as an <code>int</code>
	 */
	public static int getType(int event) {
		throw new RuntimeException();
	}

	/**
	 * Returns the event's data issued by a generator.
	 *
	 * @param event
	 *            an event
	 * @return event's data as an <code>int</code>
	 */
	public static int getData(int event) {
		throw new RuntimeException();
	}

	/**
	 * Returns the event's generator identifier.
	 *
	 * @param event
	 *            an event
	 * @return event's generator as an <code>int</code>
	 */
	public static int getGeneratorId(int event) {
		throw new RuntimeException();
	}

	/**
	 * Gets a converter out of an event assuming the event has been generated by an {@link EventGenerator} that has been
	 * previously added to the system pool.
	 *
	 * @param event
	 *            an event
	 * @return the event generator or null.
	 * @throws IllegalArgumentException
	 *             if there is no generator associated to this event.
	 * @throws MicroUIException
	 *             if MicroUI is not started
	 * @see EventGenerator#addToSystemPool()
	 */
	public static EventGenerator getGenerator(int event) {
		throw new RuntimeException();
	}
}
