/*
 * Java
 *
 * Copyright 2010-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event.generator;

import ej.microui.event.Event;
import ej.microui.event.EventGenerator;

/**
 * A Buttons event generator is usually associated to a group of physical buttons and allow to generate events relating
 * to them.<br>
 * <p>
 * For a specified subset of buttons it holds the elapsed time since the last event occurrence for that button and
 * supports the optional generation of click and double click events. Note that Buttons pre-configured by the system
 * normally support these extended features for all their buttons. However, it is implementation dependent whether or
 * not the features are enabled by default.<br>
 * <p>
 * This class defines generic button actions : {@link #PRESSED}, {@link #RELEASED}, {@link #LONG}, {@link #REPEATED},
 * {@link #CLICKED} and {@link #DOUBLE_CLICKED}.<br>
 * <p>
 * Buttons allows a button to have at most 256 kind of actions per button. Each Buttons may be associated with at most
 * 256 buttons.<br>
 * <p>
 * This class also contains a number of static helper methods that return information extracted from an event.
 */
public class Buttons extends EventGenerator {

	/**
	 * The "pressed" action.<br>
	 */
	public static final int PRESSED = 0x00;

	/**
	 * The "released" action.<br>
	 */
	public static final int RELEASED = 0x01;

	/**
	 * The "long" action (button pressed for a "long" time).<br>
	 */
	public static final int LONG = 0x02;

	/**
	 * The "repeated" action (button held down).<br>
	 */
	public static final int REPEATED = 0x03;

	/**
	 * The "clicked" action.<br>
	 */
	public static final int CLICKED = 0x04;

	/**
	 * The "double clicked" action.<br>
	 */
	public static final int DOUBLE_CLICKED = 0x05;

	/**
	 * Creates a buttons event generator where elapsedTime, click and doubleClick features are supported and enabled for
	 * the first <code>nbButtons</code> (doubleClick feature is initialized with a 200ms delay).
	 *
	 * @see #Buttons()
	 * @param nbButtons
	 *            the number of buttons that support the extended features
	 */
	public Buttons(int nbButtons) {
		throw new RuntimeException();
	}

	/**
	 * Creates a buttons event generator that does not support click, doubleClick nor elapsedTime for any of its
	 * buttons. The effect is identical to:<br>
	 * <code>new Buttons(0)</code>.
	 */
	public Buttons() {
		throw new RuntimeException();
	}

	/**
	 * For the given button, specify whether the generator should send a click event for each pressed event. Note that
	 * this method has no effect if <code>buttonID</code> refers to a button that does not have support for click events
	 * (see {@link #Buttons(int)}).
	 *
	 * @param enable
	 *            <code>true</code> to enable the click function on the button
	 * @param buttonID
	 *            the button
	 */
	public void enableClick(boolean enable, int buttonID) {
		throw new RuntimeException();
	}

	/**
	 * For the given button, specify whether the generator should send a double click event. Note that this method has
	 * no effect if <code>buttonID</code> refers to a button that does not have support for doubleClick events (see
	 * {@link #Buttons(int)}).
	 *
	 * @param enable
	 *            <code>true</code> to enable the double click function on the button. Click event is also enabled if it
	 *            was not.
	 * @param click
	 *            the maximum time elapsed between two clicks (in milliseconds) to generate a double click event
	 * @param buttonID
	 *            the button
	 */
	public void enableDoubleClick(boolean enable, int click, int buttonID) {
		throw new RuntimeException();
	}

	/**
	 * Returns <code>true</code> if the button supports the extended features elapsedTime, click and doubleClick
	 * features.
	 *
	 * @param buttonID
	 *            the button
	 * @return <code>true</code> if the button supports the extended features. and double click.
	 */
	public boolean supportsExtendedFeatures(int buttonID) {
		throw new RuntimeException();
	}

	/**
	 * Returns <code>true</code> if the generator should send a click event. Note that this method has no effect if
	 * <code>buttonID</code> refers to a button that does not have support for click events (see {@link #Buttons(int)}).
	 *
	 * @param buttonID
	 *            the button
	 * @return <code>true</code> if the generator should send a click event.
	 */
	public boolean clickEnabled(int buttonID) {
		throw new RuntimeException();
	}

	/**
	 * Returns <code>true</code> if the generator should send a double click event. Note that this method has no effect
	 * if <code>buttonID</code> refers to a button that does not have support for double click events (see
	 * {@link #Buttons(int)} ).
	 *
	 * @param buttonID
	 *            the button
	 * @return <code>true</code> if the generator should send a dooble click event.
	 */
	public boolean doubleClickEnabled(int buttonID) {
		throw new RuntimeException();
	}

	/**
	 * Returns the MicroUI event type for this button event generator. Default value is {@link Event#BUTTON}.
	 *
	 * @return the event type
	 */

	@Override
	public int getEventType() {
		throw new RuntimeException();
	}

	/**
	 * Tells if a button event is a press event.
	 *
	 * @param event
	 *            the button event.
	 * @return true if the button event is a press event.
	 */
	public static boolean isPressed(int event) {
		throw new RuntimeException();
	}

	/**
	 * Tells if a button event is a release event.
	 *
	 * @param event
	 *            the button event.
	 * @return true if the button event is a release event.
	 */
	public static boolean isReleased(int event) {
		throw new RuntimeException();
	}

	/**
	 * Tells if a button event is a repeat event.
	 *
	 * @param event
	 *            the button event.
	 * @return true if the button event is a repeat event.
	 */
	public static boolean isRepeated(int event) {
		throw new RuntimeException();
	}

	/**
	 * Tells if an button event is a long event.
	 *
	 * @param event
	 *            the button event.
	 * @return true if the button event is a long event.
	 */
	public static boolean isLong(int event) {
		throw new RuntimeException();
	}

	/**
	 * Tells if an button event is a click event.
	 *
	 * @param event
	 *            the button event.
	 * @return true if the button event is a click event.
	 */
	public static boolean isClicked(int event) {
		throw new RuntimeException();
	}

	/**
	 * Tells if an button event is a double click event.
	 *
	 * @param event
	 *            the button event.
	 * @return true if the button event is a double click event.
	 */
	public static boolean isDoubleClicked(int event) {
		throw new RuntimeException();
	}

	/**
	 * Returns the button's id held by the button event.
	 *
	 * @param event
	 *            the button event.
	 * @return the button's id held by the button event.
	 */
	public static int getButtonID(int event) {
		throw new RuntimeException();
	}

	/**
	 * Returns the button's action held by the button event.
	 *
	 * @param event
	 *            the button event.
	 * @return the button's action held by the button event.
	 */
	public static int getAction(int event) {
		throw new RuntimeException();
	}

	/**
	 * Returns the elapsed time in milliseconds between the two previous {@link #PRESSED} events that occurred on the
	 * specified button. The elapsedTime for the very first occurrence has no meaning.
	 *
	 * @param buttonID
	 *            the button on which to get the elapsed time
	 * @return the elapsed time in milliseconds or -1 when the elapsedTime has no meaning or if <code>buttonID</code>
	 *         refers to a button that does not have support for elapsedTime (see {@link #Buttons(int)})
	 */
	public long elapsedTime(int buttonID) {
		throw new RuntimeException();
	}

	/**
	 * Sends a MicroUI event for the given action on given button to the listener of the Buttons. Buttons will generate
	 * a will generate a {@link #CLICKED} and/or {@link #DOUBLE_CLICKED} events if the matching button's feature is
	 * enabled.<br>
	 * <p>
	 * This method is useful when other input mechanisms wish to simulate button actions.
	 *
	 * @param action
	 *            the button's action: {@link #PRESSED}, {@link #RELEASED}, {@link #LONG}, {@link #REPEATED}.
	 * @param buttonID
	 *            the button on which the action occurred
	 */
	public void send(int action, int buttonID) {
		throw new RuntimeException();
	}

}
