/*
 *	Java
 *
 *	Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 *	MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Renderable;

/**
 * This class holds a context in order to perform a free rotation (0 to 360 degrees) on images.
 * <p>
 * An image rotation instance holds a global state for all drawings. Several instances can be created at the same time.
 * However a default instance is created on MicroUI framework startup and is always available.
 *
 * @since 2.0
 * @deprecated Use {@link Rotate} instead.
 */
@Deprecated
public class ImageRotation extends Rotate {

	/**
	 * Default instance created on MicroUI framework startup.
	 */
	public static final ImageRotation Singleton = new ImageRotation();

	/**
	 * Draws the given {@link Image} applying the current rotation.
	 *
	 * @deprecated Use {@link Rotate#drawBilinear(GraphicsContext, Renderable, int, int, int)} instead.
	 */
	@Deprecated
	public void drawBilinear(GraphicsContext gc, Image image, int x, int y, int anchor) {
		throw new RuntimeException();
	}

	/**
	 * Draws the given {@link Image} applying the current rotation. v
	 *
	 * @deprecated Use {@link Rotate#drawNearestNeighbor(GraphicsContext, Renderable, int, int, int)} instead.
	 */
	@Deprecated
	public void drawNearestNeighbor(GraphicsContext gc, Image image, int x, int y, int anchor) {
		throw new RuntimeException();
	}

}
