/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.audio.format;

import ej.audio.AudioFormat;

/**
 * {@link AudioFormat} which represents data with the PCM (Pulse-Code Modulation) encoding.
 */
public class PcmAudioFormat extends AudioFormat {

	/**
	 * Creates a PCM audio format.
	 *
	 * @param sampleRate
	 *            the sample rate (in Hz).
	 * @param numChannels
	 *            the number of channels.
	 * @param bitDepth
	 *            the bit depth (the number of bits per sample).
	 * @param isBigEndian
	 *            whether the data is in big endian or in little endian.
	 * @param isSigned
	 *            whether the data is signed or unsigned.
	 * @throws IllegalArgumentException
	 *             if the given sample rate, the given number of channels or the given bit depth is less than or equal
	 *             to zero.
	 */
	public PcmAudioFormat(int sampleRate, int numChannels, int bitDepth, boolean isBigEndian, boolean isSigned) {
		throw new RuntimeException();
	}

	@Override
	protected String getEncoding() {
		throw new RuntimeException();
	}

	@Override
	protected int[] getParameters() {
		throw new RuntimeException();
	}
}
