/*
 * Java
 *
 * Copyright 2018-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.net.util;

import ej.util.message.MessageBuilder;
import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageLogger;

/**
 * Gather error messages.
 */
public final class Messages {

	// ****************//
	// Error messages. //
	// ****************//
	/**
	 * Unknown error.
	 */
	public static final int ERROR_UNKNOWN = -255;

	/**
	 * Could not get ntp time.
	 */
	public static final int ERROR_NTP_REQUEST = -1;

	/**
	 * No interface found.
	 */
	public static final int ERROR_NO_INTERFACE = -2;

	/**
	 * Error while getting IP.
	 */
	public static final int ERROR_COULD_NOT_GET_IP = -3;

	/**
	 * Category message errors.
	 */
	public static final String CATEGORY = Messages.class.getPackage().getName();

	/**
	 * The message builder.
	 */
	public static final MessageBuilder BUILDER = BasicMessageLogger.INSTANCE.getMessageBuilder();

	/**
	 * The message logger.
	 */
	public static final MessageLogger LOGGER = BasicMessageLogger.INSTANCE;

	private Messages() {
		// Forbid instantiation
	}
}
