/*
 * Java
 *
 * Copyright 2015-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

import java.io.InputStream;

/**
 *
 */
public interface CommandSender {

	/**
	 * Starts a command.
	 * <p>
	 * A command can be followed by arguments.
	 *
	 * @param command
	 *            the command name.
	 */
	void startCommand(String command);

	/**
	 * Sends a string parameter.
	 *
	 * @param string
	 *            the string to send.
	 */
	void sendString(String string);

	/**
	 * Sends a long parameter.
	 *
	 * @param l
	 *            the long to send.
	 */
	void sendLong(long l);

	/**
	 * Sends an integer parameter.
	 *
	 * @param i
	 *            the integer to send.
	 */
	void sendInt(int i);

	/**
	 * Sends a float parameter.
	 *
	 * @param f
	 *            the float to send.
	 */
	void sendFloat(float f);

	/**
	 * Sends a double parameter.
	 *
	 * @param d
	 *            the double to send.
	 */
	void sendDouble(double d);

	/**
	 * Sends a boolean parameter.
	 *
	 * @param b
	 *            the boolean to send.
	 */
	void sendBoolean(boolean b);

	/**
	 * Sends a byte array parameter.
	 *
	 * @param a
	 *            the byte array to send.
	 */
	void sendByteArray(byte[] a);

	/**
	 * Sends a byte array parameter using an input stream.
	 * <p>
	 * The given input stream is fully read.
	 *
	 * @param is
	 *            the input stream to send.
	 *
	 * @deprecated Use sendByteArray or sendInputStream instead.
	 */
	@Deprecated
	void sendByteArrayAsInputStream(InputStream is);

	/**
	 * Sends an input stream.
	 *
	 * @param is
	 *            the input stream to send.
	 */
	void sendInputStream(InputStream is);

	/**
	 * Ends the command frame.
	 */
	void flushCommand();

}