/*
 * Java
 *
 * Copyright 2021-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 *
 * This File is a derivative work. Subject to §4 of the applicable Apache License, MicroEJ provides the above different license terms and conditions for use.
 *
 * // Copyright (C) 2006 The Android Open Source Project
 * //
 * // Licensed under the Apache License, Version 2.0 (the "License");
 * // you may not use this file except in compliance with the License.
 * // You may obtain a copy of the License at
 * //
 * //      http://www.apache.org/licenses/LICENSE-2.0
 * //
 * // Unless required by applicable law or agreed to in writing, software
 * // distributed under the License is distributed on an "AS IS" BASIS,
 * // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * // See the License for the specific language governing permissions and
 * // limitations under the License.
 */
package ej.microvg;

/**
 * Represents a linear gradient on a vector.
 */
public class LinearGradient {

	/**
	 * Creates a linear gradient.
	 *
	 * @param xStart
	 *            the x-coordinate for the start of the gradient vector
	 * @param yStart
	 *            the y-coordinate for the start of the gradient vector
	 * @param xEnd
	 *            the x-coordinate for the end of the gradient vector
	 * @param yEnd
	 *            the y-coordinate for the end of the gradient vector
	 * @param colors
	 *            the sRGB colors to be distributed along the gradient vector
	 * @param positions
	 *            the relative positions [0..1] of each corresponding color in the colors array
	 */
	public LinearGradient(float xStart, float yStart, float xEnd, float yEnd, int[] colors, float[] positions) {
		throw new VectorGraphicsException();
	}

	/**
	 * Creates a linear gradient.
	 * <p>
	 * The colors are distributed evenly along the gradient vector.
	 *
	 * @param xStart
	 *            the x-coordinate for the start of the gradient vector
	 * @param yStart
	 *            the y-coordinate for the start of the gradient vector
	 * @param xEnd
	 *            the x-coordinate for the end of the gradient vector
	 * @param yEnd
	 *            the y-coordinate for the end of the gradient vector
	 * @param colors
	 *            the sRGB colors to be distributed along the gradient vector
	 */
	public LinearGradient(float xStart, float yStart, float xEnd, float yEnd, int[] colors) {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the matrix of this linear gradient.
	 * <p>
	 * Any modification on the matrix will affect the gradient.
	 *
	 * @return the matrix
	 */
	public Matrix getMatrix() {
		throw new VectorGraphicsException();
	}

}
