/*
 * Java
 *
 * Copyright 2018-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth;

import ej.annotation.Nullable;

/**
 * The <code>BluetoothUuid</code> class represents the UUID of a service or attribute.
 * <p>
 * UUIDs may be created from byte arrays or strings representing 128-bit UUIDs or from integers representing 16-bit
 * Bluetooth UUIDs.
 * <p>
 * A string representation of a UUID may be retrieved by calling the {@link #toString toString()} method of the object.
 * The {@link #equals(Object)} method may be used in order to check if a UUID is equal to an other.
 */
public class BluetoothUuid {

	/**
	 * Creates a UUID from a byte array.
	 *
	 * @param bytes
	 *            a byte array containing a 128-bit UUID (in big-endian).
	 * @param offset
	 *            the offset of the UUID in the byte array.
	 * @throws IllegalArgumentException
	 *             if the given byte array is not 16 bytes long.
	 */
	public BluetoothUuid(byte[] bytes, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Creates a UUID from a string.
	 *
	 * @param string
	 *            a string representing a 128-bit UUID (in big-endian).
	 * @throws IllegalArgumentException
	 *             if the given string does not represent a 128-bit UUID.
	 */
	public BluetoothUuid(String string) {
		throw new RuntimeException();
	}

	/**
	 * Creates a UUID from an integer.
	 *
	 * @param value
	 *            an integer representing a 16-bit Bluetooth UUID.
	 */
	public BluetoothUuid(int value) {
		throw new RuntimeException();
	}

	/**
	 * Writes this UUID to the given byte array.
	 *
	 * @param buffer
	 *            the buffer to write to (in big-endian).
	 * @param offset
	 *            the index in the buffer to write at.
	 * @throws ArrayIndexOutOfBoundsException
	 *             if the given buffer is not big enough to hold the UUID.
	 */
	public void getBytes(byte[] buffer, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this UUID is a 16-bit Bluetooth UUID.
	 *
	 * @return true if this UUID is a 16-bit Bluetooth UUID, false otherwise.
	 */
	public boolean is16Bit() {
		throw new RuntimeException();
	}

	/**
	 * Returns the integer representing this 16-bit Bluetooth UUID.
	 *
	 * @return the integer representing this 16-bit Bluetooth UUID.
	 * @throws IllegalStateException
	 *             if this UUID is not a 16-bit Bluetooth UUID.
	 */
	public short get16BitValue() {
		throw new RuntimeException();
	}

	/**
	 * Returns a string representation of this UUID (in big-endian).
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this UUID is equal to the given object.
	 */
	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Returns the hash code value of this UUID.
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}
}
