/*
 * Java
 *
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.tool.ui.generator;

import java.awt.image.BufferedImage;

import javax.imageio.ImageIO;

/**
 * Default {@link MicroUIRawImageGeneratorExtension} which uses the J2SE API
 * {@link ImageIO#read(javax.imageio.stream.ImageInputStream)} to read data from
 * the input image. This implementation considers the input image is a PNG, a
 * JPEG or another standard image format.
 * <p>
 * This extension can be sub-classed to specify a custom header, stride etc.
 */
public class BufferedImageLoader implements MicroUIRawImageGeneratorExtension {

	private Image image;
	private BufferedImage bi;

	@Override
	public boolean canRead(Image image) {
		try {
			this.bi = ImageIO.read(image.getInputData());
			this.image = image;
			return true;
		} catch (Exception e) {
			// cannot read this image
			return false;
		}
	}

	/**
	 * Returns the current source image used.
	 *
	 * @return the source image.
	 */
	public Image getImage() {
		return image;
	}

	@Override
	public int getWidth() {
		return bi.getWidth();
	}

	@Override
	public int getHeight() {
		return bi.getHeight();
	}

	@Override
	public int get(int x, int y) {
		return bi.getRGB(x, y);
	}
}
