/*
 * Java
 *
 * Copyright 2017-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.junit;

public interface TestListener {

	void testSuiteStarted(String name);

	void testBeforeClassMethod(String testClass, String methodName);

	void testInstance(String testClass);

	void testBeforeMethod(String testClass, String methodName);

	void testStarted(String testClass, String testMethod);

	void testSuccess(String testClass, String testMethod, long duration);

	void testFailure(String testClass, String testMethod, long duration, Throwable error, String errorMessage);

	void testError(String testClass, String testMethod, long duration, Throwable error, String errorMessage);

	void testAfterMethod(String testClass, String methodName);

	void testAfterClassMethod(String testClass, String methodName);

	void testSuiteEnded(String name, int runs, int failures, int errors);

}
