/*
 * Java
 *
 * Copyright 2012-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.benchmark.time;

/**
 * This class implements a time strategy over the
 * {@link System#currentTimeMillis()}.
 */
public class SystemCurrentTimeStrategy implements TimeStrategy {

	private static final int ONE_MILLISECOND_IN_NANOSECONDS = 1_000_000;

	@Override
	public long getTime() {
		return System.currentTimeMillis() * ONE_MILLISECOND_IN_NANOSECONDS;
	}

}
