/*
 * Copyright 2014-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.util.logging.handler;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * This is the default handler for logging. It is associated with the RootLogger by default.
 */
public class DefaultHandler extends Handler {

	@Override
	public void close() throws SecurityException {
		// Nothing to do
	}

	@Override
	public void flush() {
		// Nothing to do
	}

	@Override
	public void publish(LogRecord record) {
		System.err.println(record.getLoggerName() + " " + record.getLevel() + ": " + record.getMessage());
		Throwable thrown = record.getThrown();
		if (thrown != null) {
			thrown.printStackTrace(System.err);
		}
	}

}
