/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth.callbacks;

import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothDevice;

/**
 * The <code>ScanCallbacks</code> interface provides callbacks related to scanning.
 * <p>
 * When {@link BluetoothAdapter#startScanning starting to scan}, the application should give the scan callbacks in order
 * to be notified of the events related to the scan.
 */
public interface ScanCallbacks {

	/**
	 * Called when a advertisement or a scan response is received.
	 *
	 * @param adapter
	 *            the adapter which is performing the scan.
	 * @param device
	 *            the device which has sent the advertisement.
	 * @param payload
	 *            the advertisement data.
	 * @param rssi
	 *            the RSSI measurement.
	 * @see BluetoothAdapter#startScanning(ScanCallbacks)
	 * @see BluetoothAdapter#stopScanning()
	 */
	void onScanResult(BluetoothAdapter adapter, BluetoothDevice device, byte[] payload, int rssi);

	/**
	 * Called when an ongoing scan is completed.
	 *
	 * @param adapter
	 *            the adapter which was performing the scan.
	 * @see BluetoothAdapter#startScanning(ScanCallbacks)
	 * @see BluetoothAdapter#stopScanning()
	 */
	void onScanCompleted(BluetoothAdapter adapter);
}
