/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth.callbacks;

import ej.bluetooth.BluetoothAdapter;

/**
 * The <code>AdvertisementCallbacks</code> interface provides callbacks related to advertising.
 * <p>
 * When {@link BluetoothAdapter#startAdvertising starting to advertise}, the application should give the advertisement
 * callbacks in order to be notified of the events related to the advertisement.
 */
public interface AdvertisementCallbacks {

	/**
	 * Called when an ongoing advertisement is completed.
	 *
	 * @param adapter
	 *            the adapter which was performing the advertisement.
	 * @see BluetoothAdapter#startAdvertising(AdvertisementCallbacks, ConnectionCallbacks, byte[])
	 * @see BluetoothAdapter#stopAdvertising()
	 */
	void onAdvertisementCompleted(BluetoothAdapter adapter);
}
