/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.websocket.util;

import ej.websocket.Endpoint;
import ej.websocket.ReasonForClosure;
import ej.websocket.WebSocket;

/**
 * An {@link Endpoint} with a default behaviour doing nothing.
 */
public abstract class EndpointAdapter implements Endpoint {

	@Override
	public byte[] onBinaryMessage(WebSocket ws, byte[] message) {
		return null;
	}

	@Override
	public void onClose(WebSocket ws, ReasonForClosure closeReason) {
	}

	@Override
	public void onError(WebSocket ws, Throwable thr) {
	}

	@Override
	public void onOpen(WebSocket ws) {
	}

	@Override
	public void onPong(byte[] data) {
	}

	@Override
	public String onTextMessage(WebSocket ws, String message) {
		return null;
	}

}
