package java.lang.annotation;

/**
 * Indicates how long annotations with the annotated type are to be retained. If no Retention
 * annotation is present on an annotation type declaration, the retention policy defaults to
 * {@code RetentionPolicy.CLASS}.
 *
 * <p>
 * A Retention meta-annotation has effect only if the meta-annotated type is used directly for
 * annotation. It has no effect if the meta-annotated type is used as a member type in another
 * annotation type.
 *
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.ANNOTATION_TYPE)
public @interface Retention {

	/**
	 * Returns the retention policy.
	 * 
	 * @return the retention policy
	 */
	@SuppressWarnings("null") // NOSONAR explicitly declared to avoid Eclipse 2020 JDT builder errors.
	RetentionPolicy value();
}
