/*
 * 2011-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.bon;

/**
 * This class provides some utilities to manage I/O on a byte array.
 */
public class ByteArray {

	/**
	 * Access mode little endian.
	 */
	public static final int LITTLE_ENDIAN = 0;

	/**
	 * Access mode big endian.
	 */
	public static final int BIG_ENDIAN = 1;

	/**
	 * The size of a byte.
	 */
	public static final int BYTE_SIZE = 1;

	/**
	 * The size of a char.
	 */
	public static final int CHAR_SIZE = 2;

	/**
	 * The size of a short.
	 */
	public static final int SHORT_SIZE = 2;

	/**
	 * The size of an int.
	 */
	public static final int INT_SIZE = 4;

	/**
	 * The size of a long.
	 */
	public static final int LONG_SIZE = 8;

	/**
	 * Gets whether the platform is in big endian or little endian.
	 *
	 * @return {@link #BIG_ENDIAN} if the platform is in big endian,
	 *         {@link #LITTLE_ENDIAN} if in little endian
	 */
	public static int getPlatformEndianness() {
		throw new RuntimeException();
	}

	/**
	 * Reads an unsigned-byte in the given byte array at the given offset respecting
	 * the endianness of the platform.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #BYTE_SIZE
	 */
	public static int readUnsignedByte(byte[] array, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Reads a short in the given byte array at the given offset respecting the
	 * endianness of the platform.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #SHORT_SIZE
	 */
	public static short readShort(byte[] array, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Reads a char in the given byte array at the given offset respecting the
	 * endianness of the platform.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #CHAR_SIZE
	 */
	public static char readChar(byte[] array, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Reads an int in the given byte array at the given offset respecting the
	 * endianness of the platform.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #INT_SIZE
	 */
	public static int readInt(byte[] array, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Reads a long in the given byte array at the given offset respecting the
	 * endianness of the platform.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #LONG_SIZE
	 */
	public static long readLong(byte[] array, int offset) {
		throw new RuntimeException();
	}

	/**
	 * Reads a short in the given byte array at the given offset respecting the
	 * endianness of the array.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @param endianness
	 *            the access mode ({@link #BIG_ENDIAN} or {@link #LITTLE_ENDIAN})
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #SHORT_SIZE
	 */
	public static short readShort(byte[] array, int offset, int endianness) {
		throw new RuntimeException();
	}

	/**
	 * Reads a char in the given byte array at the given offset respecting the
	 * endianness of the array.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @param endianness
	 *            the access mode ({@link #BIG_ENDIAN} or {@link #LITTLE_ENDIAN})
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #CHAR_SIZE
	 */
	public static char readChar(byte[] array, int offset, int endianness) {
		throw new RuntimeException();
	}

	/**
	 * Reads an int in the given byte array at the given offset respecting the
	 * endianness of the array.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @param endianness
	 *            the access mode ({@link #BIG_ENDIAN} or {@link #LITTLE_ENDIAN})
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #INT_SIZE
	 */
	public static int readInt(byte[] array, int offset, int endianness) {
		throw new RuntimeException();
	}

	/**
	 * Reads a long in the given byte array at the given offset respecting the
	 * endianness of the array.
	 *
	 * @param array
	 *            the byte array to read in
	 * @param offset
	 *            the offset of the value to read
	 * @param endianness
	 *            the access mode ({@link #BIG_ENDIAN} or {@link #LITTLE_ENDIAN})
	 * @return the read value
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if read outside the bounds of the given array
	 * @see #LONG_SIZE
	 */
	public static long readLong(byte[] array, int offset, int endianness) {
		throw new RuntimeException();
	}

	/**
	 * Writes a short in the given byte array at the given offset respecting the
	 * endianness of the platform.
	 *
	 * @param array
	 *            the byte array to write in
	 * @param offset
	 *            the offset of the value to write
	 * @param value
	 *            the value to write
	 * @throws NullPointerException
	 *             if the given array is null
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 * @see #SHORT_SIZE
	 */
	public static void writeShort(byte[] array, int offset, int value) {
		throw new RuntimeException();
	}

	/**
	 * Writes an int in the given byte array at the given offset respecting the
	 * endianness of the platform.
	 *
	 * @param array
	 *            the byte array to write in
	 * @param offset
	 *            the offset of the value to write
	 * @param value
	 *            the value to write
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 * @see #INT_SIZE
	 */
	public static void writeInt(byte[] array, int offset, int value) {
		throw new RuntimeException();
	}

	/**
	 * Writes a long in the given byte array at the given offset respecting the
	 * endianness of the platform.
	 *
	 * @param array
	 *            the byte array to write in
	 * @param offset
	 *            the offset of the value to write
	 * @param value
	 *            the value to write
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 * @see #LONG_SIZE
	 */
	public static void writeLong(byte[] array, int offset, long value) {
		throw new RuntimeException();
	}

	/**
	 * Writes a short in the given byte array at the given offset respecting the
	 * endianness of the array.
	 *
	 * @param array
	 *            the byte array to write in
	 * @param offset
	 *            the offset of the value to write
	 * @param value
	 *            the value to write
	 * @param endianness
	 *            the access mode ({@link #BIG_ENDIAN} or {@link #LITTLE_ENDIAN})
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 * @see #SHORT_SIZE
	 */
	public static void writeShort(byte[] array, int offset, int value, int endianness) {
		throw new RuntimeException();
	}

	/**
	 * Writes an int in the given byte array at the given offset respecting the
	 * endianness of the array.
	 *
	 * @param array
	 *            the byte array to write in
	 * @param offset
	 *            the offset of the value to write
	 * @param value
	 *            the value to write
	 * @param endianness
	 *            the access mode ({@link #BIG_ENDIAN} or {@link #LITTLE_ENDIAN})
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 * @see #INT_SIZE
	 */
	public static void writeInt(byte[] array, int offset, int value, int endianness) {
		throw new RuntimeException();
	}

	/**
	 * Writes a long in the given byte array at the given offset respecting the
	 * endianness of the array.
	 *
	 * @param array
	 *            the byte array to write in
	 * @param offset
	 *            the offset of the value to write
	 * @param value
	 *            the value to write
	 * @param endianness
	 *            the access mode ({@link #BIG_ENDIAN} or {@link #LITTLE_ENDIAN})
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 * @see #LONG_SIZE
	 */
	public static void writeLong(byte[] array, int offset, long value, int endianness) {
		throw new RuntimeException();
	}

	/**
	 * Fills a zone of a byte array with <code>0</code>.
	 *
	 * @param array
	 *            the byte array to clear
	 * @param offset
	 *            the offset of the zone to clear
	 * @param length
	 *            the length of the zone to clear
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 */
	public static void clear(byte[] array, int offset, int length) {
		throw new RuntimeException();
	}

	/**
	 * Fills a zone of a byte array with the given value.
	 *
	 * @param array
	 *            the byte array to set
	 * @param value
	 *            the value to fill the zone with
	 * @param offset
	 *            the offset of the zone to set
	 * @param length
	 *            the length of the zone to set
	 * @throws ArrayIndexOutOfBoundsException
	 *             if write outside the bounds of the given array
	 */
	public static void set(byte[] array, byte value, int offset, int length) {
		throw new RuntimeException();
	}

}
