/*
 * Java
 *
 * 2014-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.kf;

import ej.annotation.Nullable;
import ej.kf.Feature.State;

/**
 * The listener interface for receiving notifications when the state of a Feature has changed.
 * Object instances of classes that implement this interface must be added to the Kernel listener list
 * using {@link Kernel#addFeatureStateListener(FeatureStateListener)}
 */
public interface FeatureStateListener {

	/**
	 * Called when the state of a Feature has changed.
	 * @param feature the Feature which state has changed
	 * @param previousState the previous state, <code>null</code> if Feature state is {@link State#INSTALLED}
	 */
	public void stateChanged(Feature feature, @Nullable State previousState);

}
