/*
 * Java
 *
 * 2013-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.kf;

/**
 * This exception is thrown if a Feature being loaded has already been loaded.
 * @see Kernel#load(java.io.InputStream) 
 */
public class AlreadyLoadedFeatureException extends Exception{

	/**
	 * Creates an {@link AlreadyLoadedFeatureException} with the previously loaded {@link Feature}.
	 * @param feature the previously loaded {@link Feature}
	 */
	public AlreadyLoadedFeatureException(Feature feature){
		throw new RuntimeException();
	}
	
	/**
	 * Returns the previously loaded {@link Feature}.
	 * @return the previously loaded {@link Feature}.
	 */
	public Feature getFeature(){
		throw new RuntimeException();
	}
}
