/*
 * Copyright 2013-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.kf;

/**
 * Handler for uncaught exceptions thrown in a Feature.
 *
 * @deprecated Use {@link java.lang.Thread.UncaughtExceptionHandler}
 */
@Deprecated
public interface UncaughtExceptionHandler {

	/**
	 * Method invoked when the given thread terminates due to the given uncaught exception.
	 * <p>
	 * Any exception thrown by this method will be ignored by the Java Virtual Machine.
	 *
	 * @param f
	 *            the feature
	 * @param t
	 *            the thread
	 * @param e
	 *            the exception
	 */
	public void uncaughtException(Feature f, Thread t, Throwable e);

}
