/*
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.audio;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class represents access rights to audio tracks.
 * <p>
 * The actions are:
 * <dl>
 * <dt>{@link #CREATE_ACTION}
 * <dd>Permission is checked when creating an {@link AudioTrack}.
 * <dt>{@link #WRITE_ACTION}
 * <dd>Permission is checked when writing to an {@link AudioTrack} ({@link AudioTrack#writeBuffer(byte[], int, int)}).
 * <dt>{@link #WAIT_ACTION}
 * <dd>Permission is checked when waiting for an {@link AudioTrack} ({@link AudioTrack#waitForBufferFlushed()}).
 * </dl>
 *
 * @see java.security.Permission
 */
public class AudioTrackPermission extends Permission {

	private static final long serialVersionUID = -2610566751530645807L;

	/**
	 * The action when creating an {@link AudioTrack}.
	 */
	public static final String CREATE_ACTION = "create";
	/**
	 * The action when writing to an {@link AudioTrack}.
	 */
	public static final String WRITE_ACTION = "write";
	/**
	 * The action when waiting for an {@link AudioTrack}.
	 */
	public static final String WAIT_ACTION = "wait";

	private AudioTrackPermission() {
		super(null);
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
