/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 *
 * This File is a derivative work. Subject to §4 of the applicable Apache License, MicroEJ provides the above different license terms and conditions for use.
 *
 * // Copyright (C) 2006 The Android Open Source Project
 * //
 * // Licensed under the Apache License, Version 2.0 (the "License");
 * // you may not use this file except in compliance with the License.
 * // You may obtain a copy of the License at
 * //
 * //      http://www.apache.org/licenses/LICENSE-2.0
 * //
 * // Unless required by applicable law or agreed to in writing, software
 * // distributed under the License is distributed on an "AS IS" BASIS,
 * // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * // See the License for the specific language governing permissions and
 * // limitations under the License.
 */
package ej.microvg;

/**
 * Enum for the ways a path is blend.
 */
public enum BlendMode {
	/**
	 * The source pixels replace the destination pixels.
	 * <p>
	 * \(\alpha_{out} = \alpha_{src}\)
	 * <p>
	 * \(C_{out} = C_{src}\)
	 */
	SRC,

	/**
	 * The source pixels are drawn over the destination pixels.
	 * <p>
	 * \(\alpha_{out} = \alpha_{src} + (1 - \alpha_{src}) * \alpha_{dst}\)
	 * <p>
	 * \(C_{out} = C_{src} + (1 - \alpha_{src}) * C_{dst}\)
	 */
	SRC_OVER,

	/**
	 * The source pixels are drawn behind the destination pixels.
	 * <p>
	 * \(\alpha_{out} = \alpha_{dst} + (1 - \alpha_{dst}) * \alpha_{src}\)
	 * <p>
	 * \(C_{out} = C_{dst} + (1 - \alpha_{dst}) * C_{src}\)
	 */
	DST_OVER,

	/**
	 * Keeps the source pixels that cover the destination pixels, discards the remaining source and destination pixels.
	 * <p>
	 * \(\alpha_{out} = \alpha_{src} * \alpha_{dst}\)
	 * <p>
	 * \(C_{out} = C_{src} * \alpha_{dst}\)
	 */
	SRC_IN,
}
