/*
 * Java
 *
 * 2017-2020 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.display;

/**
 * Represents graphical information related to the drawing of a string with a font.
 * <p>
 * Drawing a renderable string is faster than drawing a regular string. This optimization is done by caching the index
 * within the font of every character of the string as soon as the renderable string is created. However a
 * <code>RenderableString</code> consumes significant heap memory.
 */
public class RenderableString {

	/**
	 * Creates a renderable string.
	 *
	 * @param string
	 *            the string to draw.
	 * @param font
	 *            the font to use in order to draw the string.
	 */
	public RenderableString(String string, Font font) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string associated with this renderable string.
	 *
	 * @return the string associated with this renderable string.
	 */
	public String getString() {
		throw new RuntimeException();
	}

	/**
	 * Returns the characters array associated with this renderable string.
	 * <p>
	 * Same array is always returned, contrary to <code>renderableString.getString().toCharArray().</code>. By
	 * consequence its content must not be modified.
	 *
	 * @return the character array associated with this renderable string.
	 * @see String#toCharArray()
	 */
	public char[] getCharArray() {
		throw new RuntimeException();
	}

	/**
	 * Returns the array of characters indices associated with this renderable string.
	 * <p>
	 * Same array is always returned; by consequence its content must not be modified.
	 *
	 * @return the indices array associated with this renderable string.
	 */
	public int[] getIndices() {
		throw new RuntimeException();
	}

	/**
	 * Returns the font associated with this renderable string.
	 *
	 * @return the font associated with this renderable string.
	 */
	public Font getFont() {
		throw new RuntimeException();
	}

	/**
	 * Returns the width of the graphical bounds of this renderable string.
	 * <p>
	 * This method has the same specifications as {@link Font#stringWidth(String)}.
	 *
	 * @return the width taken by this renderable string, in pixels.
	 */
	public int getWidth() {
		throw new RuntimeException();
	}

	/**
	 * Returns the height of the graphical bounds of this renderable string.
	 * <p>
	 * This method has the same specifications as {@link Font#getHeight()}.
	 *
	 * @return the height taken by this renderable string, in pixels.
	 */
	public int getHeight() {
		throw new RuntimeException();
	}
}
