/*
 * Copyright 2021-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.widget.motion;

/**
 * Listener for {@link MotionAnimation}.
 */
public interface MotionAnimationListener {

	/**
	 * Called regularly by the animator, unless the value has not changed.
	 * <p>
	 * The given value is within the start and stop values of the motion.
	 * <p>
	 * This method is executed in the MicroUI thread.
	 *
	 * @param value
	 *            the current value of the motion.
	 * @param finished
	 *            whether the motion is currently finished.
	 */
	void tick(int value, boolean finished);
}
