/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.security;

import java.io.InputStream;
import java.util.List;

import ej.annotation.Nullable;

/**
 * The Interface SecurityPolicyResourceLoader that handles the policy file
 * permission parsing and loading.
 */
public interface SecurityPolicyResourceLoader {

	public static final String NULL_IDENTIFIER = "null";
	public static final String ALL_IDENTIFIER = "*";

	/**
	 * Load feature permissions. Returns null if no file is found or if an exception
	 * occurred during the parsing.
	 *
	 * @param inputStream the input stream
	 * @return the list
	 */
	public @Nullable List<FeaturePolicyPermission> loadFeaturePermissions(@Nullable InputStream inputStream);
}
