/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothConnection;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class SendReadRequestEndpoint implements Endpoint {

	private final BluetoothController controller;

	private short connHandle;
	private short attributeHandle;

	public SendReadRequestEndpoint(BluetoothController controller) {
		this.controller = controller;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_READ_REQUEST;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		this.connHandle = (short) reader.readInt();
		this.attributeHandle = (short) reader.readInt();
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		BluetoothConnection connection = this.controller.getConnection(this.connHandle);
		BluetoothAttribute attribute = this.controller.getRemoteAttribute(connection, this.attributeHandle);
		if (connection != null && attribute != null && connection.sendReadRequest(attribute)) {
			sender.sendInt(Commands.OK);
		} else {
			sender.sendInt(Commands.ERROR);
		}
	}
}
