/*
 * Copyright 2019-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */

package ej.net.util.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;

/**
 * Manages the certificates of the device.
 */
public class CertificatesHelper {

	private CertificatesHelper() {
		// private constructor
	}

	/**
	 * Adds a list of certificates by reading an input stream which contains the filename of each certificate.
	 *
	 * @param certificatesList
	 *            the input stream containing the list of certificates.
	 * @return an array containing the filenames of the certificates.
	 * @throws IOException
	 *             if an exception occurs while loading the certificates list.
	 */
	public static String[] loadCertificatesList(InputStream certificatesList) throws IOException {
		Properties properties = new Properties();
		properties.load(certificatesList);
		Set<String> propertiesSet = properties.stringPropertyNames();
		return propertiesSet.toArray(new String[propertiesSet.size()]);
	}

}
