/*
 * Java
 *
 * Copyright 2018-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Integer}. This converter creates a clone of the original {@link Integer}.
 */
public class IntegerConverter implements Converter<Integer> {

	@Override
	public Integer convert(Integer arg0, Feature targetOwner) throws IllegalAccessError {
		final int value = arg0.intValue();
		RunnableWithResult<Integer> runnable = new RunnableWithResult<Integer>() {
			@Override
			public Integer runWithResult() {
				return new Integer(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Integer> getType() {
		return Integer.class;
	}

}