/*
 * Copyright 2010-2015 http://beders.github.com/Resty
 * Copyright 2015-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ej.rest.web;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

/** Used for deleting contents on a server with the DELETE method.
 * Use Resty.delete() to create an instance of this.
 * Not strictly a content, but an instruction to delete a URL.
 * 
 * @author beders
 *
 */
public class Deletion extends AbstractContent {

	@Override
	public void writeHeader(OutputStream os) throws IOException {
		// nothing to do here
	}

	@Override
	public void writeContent(OutputStream os) throws IOException {
		// no content
	}

	@Override
	protected void addContent(URLConnection con) throws IOException {
		con.setDoOutput(true);
		((HttpURLConnection)con).setRequestMethod("DELETE");
	}

}
