/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.hoka.http;

import static ej.hoka.http.HttpConstants.HTTP_STATUS_OK;

/**
 * Stop a request processing
 */
class HaltException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	private final String status;
	private final String body;

	/**
	 *
	 */
	HaltException() {
		super(null, null);
		this.status = HTTP_STATUS_OK;
		this.body = ""; //$NON-NLS-1$ // NOSONAR
	}

	/**
	 * @param status
	 *            http status
	 *
	 */
	HaltException(final String status) {
		super(null, null);
		this.status = status;
		this.body = ""; //$NON-NLS-1$ // NOSONAR
	}

	/**
	 * @param status
	 *            http status
	 * @param body
	 *            error message
	 */
	HaltException(String status, String body) {
		super(null, null);
		this.status = status;
		this.body = body;
	}

	/**
	 * Gets the status.
	 *
	 * @return the status.
	 */
	public String getStatus() {
		return this.status;
	}

	/**
	 * Gets the body.
	 *
	 * @return the body.
	 */
	public String getBody() {
		return this.body;
	}

}
