/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline.border;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;
import ej.mwt.style.outline.FlexibleOutline;
import ej.mwt.util.Size;

public class FlexibleRectangularMulticoloredBorder
extends FlexibleOutline {
    private final int colorTop;
    private final int colorBottom;
    private final int colorLeft;
    private final int colorRight;

    public FlexibleRectangularMulticoloredBorder(int top, int colorTop, int right, int colorRight, int bottom, int colorBottom, int left, int colorLeft) {
        super(top, right, bottom, left);
        this.colorTop = colorTop;
        this.colorRight = colorRight;
        this.colorBottom = colorBottom;
        this.colorLeft = colorLeft;
    }

    public int getColorTop() {
        return this.colorTop;
    }

    public int getColorBottom() {
        return this.colorBottom;
    }

    public int getColorLeft() {
        return this.colorLeft;
    }

    public int getColorRight() {
        return this.colorRight;
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        int width = size.getWidth();
        int height = size.getHeight();
        g.setColor(this.colorTop);
        int topThickness = this.getTop();
        Painter.fillRectangle((GraphicsContext)g, (int)0, (int)0, (int)width, (int)topThickness);
        g.setColor(this.colorBottom);
        int bottomThickness = this.getBottom();
        Painter.fillRectangle((GraphicsContext)g, (int)0, (int)(height - bottomThickness), (int)width, (int)bottomThickness);
        g.setColor(this.colorLeft);
        int leftThickness = this.getLeft();
        Painter.fillRectangle((GraphicsContext)g, (int)0, (int)0, (int)leftThickness, (int)height);
        g.setColor(this.colorRight);
        int rightThickness = this.getRight();
        Painter.fillRectangle((GraphicsContext)g, (int)(width - rightThickness), (int)0, (int)rightThickness, (int)height);
        super.apply(g, size);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof FlexibleRectangularMulticoloredBorder) {
            FlexibleRectangularMulticoloredBorder border = (FlexibleRectangularMulticoloredBorder)obj;
            return super.equals(obj) && this.colorTop == border.colorTop && this.colorBottom == border.colorBottom && this.colorLeft == border.colorLeft && this.colorRight == border.colorRight;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * this.colorTop * this.colorBottom * this.colorLeft * this.colorRight;
    }
}

