/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.basictool.ArrayTools;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

public class Flex
extends Container {
    private Direction direction;
    private Justify justify;
    private Align align;
    private FlexRow[] rows;

    public Flex(Direction direction, Justify justify, Align alignment) {
        this.direction = direction;
        this.justify = justify;
        this.align = alignment;
        this.rows = new FlexRow[0];
    }

    protected void computeContentOptimalSize(Size size) {
        int totalCrossSize;
        int availableWidth = size.getWidth();
        int availableHeight = size.getHeight();
        int mainAxisSize = this.getMainSize(availableWidth, availableHeight);
        int crossAxisSize = this.getCrossSize(availableWidth, availableHeight);
        if (mainAxisSize == 0) {
            this.setJustify(Justify.START);
        } else if (crossAxisSize == 0) {
            this.setAlign(Align.START);
        }
        int offset = 0;
        while (offset < super.getChildrenCount()) {
            this.computeRowSize(super.getChildren(), mainAxisSize, crossAxisSize, offset);
            offset = this.rows[this.rows.length - 1].getEndOffset();
        }
        int totalMainSize = this.getRowTotalMainSize();
        int n = totalCrossSize = this.isStretch() ? crossAxisSize : this.getRowTotalCrossSize();
        if (this.isRow()) {
            size.setSize(totalMainSize, totalCrossSize);
        } else {
            size.setSize(totalCrossSize, totalMainSize);
        }
    }

    private void computeRowSize(Widget[] widgets, int mainSize, int crossSize, int offset) {
        int mainAxisTotal = 0;
        int crossAxisMax = 0;
        while (offset < widgets.length) {
            Widget child = widgets[offset];
            assert (child != null);
            this.computeChildOptimalSize(child, mainSize, crossSize);
            int mainAxisChildLength = this.getMainSize(child.getWidth(), child.getHeight());
            int otherAxisChildLength = this.getCrossSize(child.getWidth(), child.getHeight());
            if (mainSize != 0 && mainAxisTotal + mainAxisChildLength > mainSize) break;
            mainAxisTotal += mainAxisChildLength;
            crossAxisMax = Math.max(otherAxisChildLength, crossAxisMax);
            ++offset;
        }
        this.rows = (FlexRow[])ArrayTools.add((Object[])this.rows, (Object)new FlexRow(offset, mainAxisTotal, crossAxisMax));
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        int[] rowCrossPosition = new int[]{0, 0};
        int offset = 0;
        int rowIndex = 0;
        while (rowIndex < this.rows.length) {
            this.layoutRow(super.getChildren(), this.rows, this.getMainSize(contentWidth, contentHeight), this.getCrossSize(contentWidth, contentHeight), rowCrossPosition, rowIndex, offset);
            offset = this.rows[rowIndex].getEndOffset();
            ++rowIndex;
        }
    }

    private void layoutRow(Widget[] children, FlexRow[] rows, int mainSize, int crossSize, int[] rowCrossPosition, int rowIndex, int offset) {
        FlexRow row = rows[rowIndex];
        int endOffset = row.getEndOffset();
        int numberOfChildrenInRow = endOffset - offset;
        int remainingSpace = mainSize - row.getMainRowSize();
        float justifyStart = this.computeJustifyStart(remainingSpace, numberOfChildrenInRow);
        int crossRowSize = this.calculateRowStretch(crossSize, row);
        rowCrossPosition[1] = rowCrossPosition[0] + crossRowSize;
        int i = offset;
        while (i < endOffset) {
            Widget child = children[i];
            int childWidth = child.getWidth();
            int childHeight = child.getHeight();
            int alignStart = this.computeAlignment(this.getCrossSize(childWidth, childHeight), crossRowSize, rowCrossPosition, crossSize);
            this.layOutFlexChild(child, mainSize, justifyStart, alignStart, rowCrossPosition[1]);
            justifyStart += (float)this.getMainSize(childWidth, childHeight);
            justifyStart += this.getSpaceBetweenWidgets(remainingSpace, numberOfChildrenInRow);
            ++i;
        }
        rowCrossPosition[0] = rowCrossPosition[1];
    }

    private void layOutFlexChild(Widget childWidget, int mainContentSize, double widgetStart, int rowStart, int rowEnd) {
        int height;
        int width;
        int y;
        int x;
        int childMainSize = this.getMainSize(childWidget.getWidth(), childWidget.getHeight());
        int childCrossSize = this.getCrossSize(childWidget.getWidth(), childWidget.getHeight());
        int widgetStartReverse = (int)((double)mainContentSize - widgetStart) - childMainSize;
        if (this.align == Align.STRETCH) {
            childCrossSize = rowEnd - rowStart;
        }
        boolean isReverse = this.isReverse();
        if (this.isRow()) {
            x = isReverse ? widgetStartReverse : (int)widgetStart;
            y = rowStart;
            width = childMainSize;
            height = childCrossSize;
        } else {
            x = rowStart;
            y = isReverse ? widgetStartReverse : (int)widgetStart;
            width = childCrossSize;
            height = childMainSize;
        }
        this.layOutChild(childWidget, x, y, width, height);
    }

    private float computeJustifyStart(int remainingSpace, int numChildrenInRow) {
        int start;
        switch (this.justify) {
            case SPACE_AROUND: {
                assert (numChildrenInRow != 0);
                start = remainingSpace / numChildrenInRow / 2;
                break;
            }
            case END: {
                start = remainingSpace;
                break;
            }
            case CENTER: {
                start = remainingSpace / 2;
                break;
            }
            default: {
                start = 0;
            }
        }
        return start;
    }

    private float getSpaceBetweenWidgets(int remainingSpace, int numChildrenInRow) {
        float spaceBetweenWidgets;
        switch (this.justify) {
            case SPACE_BETWEEN: {
                if (numChildrenInRow > 1) {
                    spaceBetweenWidgets = (float)remainingSpace / (float)(numChildrenInRow - 1);
                    break;
                }
                spaceBetweenWidgets = remainingSpace;
                break;
            }
            case SPACE_AROUND: {
                assert (numChildrenInRow != 0);
                spaceBetweenWidgets = (float)remainingSpace / (float)numChildrenInRow;
                break;
            }
            default: {
                spaceBetweenWidgets = 0.0f;
            }
        }
        return spaceBetweenWidgets;
    }

    private int computeAlignment(int childCrossSize, int crossRowSize, int[] rowCrossPosition, int crossContentSize) {
        int widgetCrossStart;
        int remainingSpace = crossContentSize - this.getRowTotalCrossSize();
        int rowRemainingSpace = crossRowSize - childCrossSize;
        switch (this.align) {
            case CENTER: {
                widgetCrossStart = remainingSpace / 2 + rowRemainingSpace / 2;
                break;
            }
            case END: {
                widgetCrossStart = remainingSpace + rowRemainingSpace;
                break;
            }
            default: {
                widgetCrossStart = 0;
            }
        }
        return rowCrossPosition[0] + widgetCrossStart;
    }

    private int getMainSize(int width, int height) {
        return this.isRow() ? width : height;
    }

    private int getCrossSize(int width, int height) {
        return this.isRow() ? height : width;
    }

    private int getRowTotalMainSize() {
        int total = 0;
        FlexRow[] flexRowArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            FlexRow row = flexRowArray[n2];
            total += row.getMainRowSize();
            ++n2;
        }
        return total;
    }

    private int getRowTotalCrossSize() {
        int total = 0;
        FlexRow[] flexRowArray = this.rows;
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            FlexRow row = flexRowArray[n2];
            total += row.getCrossRowSize();
            ++n2;
        }
        return total;
    }

    private int calculateRowStretch(int contentCrossSize, FlexRow currentRow) {
        return this.isStretch() ? contentCrossSize / this.rows.length : currentRow.getCrossRowSize();
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
        this.resetRows();
    }

    public void setJustify(Justify justify) {
        this.justify = justify;
        this.resetRows();
    }

    public void setAlign(Align align) {
        this.align = align;
        this.resetRows();
    }

    private void resetRows() {
        this.rows = new FlexRow[0];
    }

    public boolean isRow() {
        return this.direction == Direction.ROW || this.direction == Direction.ROW_REVERSE;
    }

    public boolean isReverse() {
        return this.direction == Direction.ROW_REVERSE || this.direction == Direction.COLUMN_REVERSE;
    }

    public boolean isStretch() {
        return this.align == Align.STRETCH;
    }

    public void addChild(Widget child) {
        super.addChild(child);
        this.resetRows();
    }

    public void removeChild(Widget childToRemove) {
        super.removeChild(childToRemove);
        this.resetRows();
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.resetRows();
    }

    public static enum Align {
        STRETCH,
        START,
        CENTER,
        END;

    }

    public static enum Direction {
        ROW,
        ROW_REVERSE,
        COLUMN,
        COLUMN_REVERSE;

    }

    private static class FlexRow {
        private final int endOffset;
        private final int mainRowSize;
        private final int crossRowSize;

        public FlexRow(int endOffset, int mainRowSize, int crossRowSize) {
            this.endOffset = endOffset;
            this.mainRowSize = mainRowSize;
            this.crossRowSize = crossRowSize;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getMainRowSize() {
            return this.mainRowSize;
        }

        public int getCrossRowSize() {
            return this.crossRowSize;
        }
    }

    public static enum Justify {
        START,
        CENTER,
        END,
        SPACE_BETWEEN,
        SPACE_AROUND;

    }
}

