/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.GraphicsContext;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

public class UniformOutline
implements Outline {
    private final char thickness;

    public UniformOutline(int thickness) {
        this.thickness = (char)XMath.limit((int)thickness, (int)0, (int)65535);
    }

    public int getThickness() {
        return this.thickness;
    }

    @Override
    public void apply(Outlineable outlineable) {
        char thickness = this.thickness;
        outlineable.removeOutline(thickness, thickness, thickness, thickness);
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        char thickness = this.thickness;
        size.removeOutline(thickness, thickness, thickness, thickness);
        g.translate((int)thickness, (int)thickness);
        g.intersectClip(0, 0, size.getWidth(), size.getHeight());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            UniformOutline outline = (UniformOutline)obj;
            return this.thickness == outline.thickness;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 19 * this.thickness;
    }
}

