/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.connectivity;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import ej.annotation.Nullable;
import ej.net.util.connectivity.SimpleNetworkCallback;

public class SimpleNetworkCallbackAdapter
extends ConnectivityManager.NetworkCallback
implements SimpleNetworkCallback {
    private boolean hasInternet;
    private boolean isConnected;
    private SimpleNetworkCallback listener;

    public SimpleNetworkCallbackAdapter() {
    }

    public SimpleNetworkCallbackAdapter(@Nullable SimpleNetworkCallback listener) {
        this.listener = listener;
    }

    public SimpleNetworkCallback getListener() {
        return this.listener;
    }

    public void setListener(@Nullable SimpleNetworkCallback listener) {
        this.listener = listener;
    }

    public void onAvailable(Network network) {
        this.isConnected = true;
        this.onConnectivity(true);
    }

    public void onLost(Network network) {
        this.isConnected = false;
        this.onConnectivity(false);
    }

    public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        this.hasInternet = networkCapabilities.hasCapability(12);
        this.onInternet(this.hasInternet);
    }

    @Override
    public void onInternet(boolean hasInternet) {
        SimpleNetworkCallback listener = this.listener;
        if (listener != null) {
            listener.onInternet(hasInternet);
        }
    }

    @Override
    public void onConnectivity(boolean isConnected) {
        SimpleNetworkCallback listener = this.listener;
        if (listener != null) {
            listener.onConnectivity(isConnected);
        }
    }

    public boolean hasInternet() {
        return this.hasInternet;
    }

    public boolean isConnected() {
        return this.isConnected;
    }
}

