/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.MouseListener;
import ej.fp.Widget;
import ej.fp.util.WidgetWithListener;
import ej.microui.event.EventTouch;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label", isOptional=true), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="width"), @Widget.WidgetAttribute(name="height"), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="areaWidth", isOptional=true), @Widget.WidgetAttribute(name="areaHeight", isOptional=true), @Widget.WidgetAttribute(name="touch", isOptional=true), @Widget.WidgetAttribute(name="listenerClass", isOptional=true)})
public class Pointer
extends WidgetWithListener
implements MouseListener {
    private static final int DELAY_MOVE_EVENTS_MS = 20;
    private PointerListener listener;
    private long lastEventTime;
    private boolean touch;
    private boolean drag;
    private int areaWidth;
    private int areaHeight;

    public void setAreaWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Area width cannot be negative.");
        }
        this.areaWidth = width;
    }

    public void setAreaHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Area height cannot be negative.");
        }
        this.areaHeight = height;
    }

    public void setTouch(boolean touch) {
        this.touch = touch;
    }

    public void setListenerClass(String listenerClassName) {
        this.setListenerClass(PointerListener.class, listenerClassName);
    }

    public synchronized void finalizeConfiguration() {
        super.finalizeConfiguration();
        if (this.areaWidth == 0) {
            this.areaWidth = this.getWidth();
        }
        if (this.areaHeight == 0) {
            this.areaHeight = this.getHeight();
        }
    }

    public void start() {
        super.start();
        this.listener = this.newListener(PointerListener.class);
    }

    @Override
    protected Object newDefaultListener() {
        return new PointerListenerToPointerEvents();
    }

    public void mouseEntered(int x, int y) {
        this.mouseMoved(x, y);
    }

    public void mouseExited(int x, int y) {
        this.mouseMoved(x, y);
    }

    public void mouseMoved(int x, int y) {
        if (!this.touch) {
            this.mouseMove(x, y);
        }
    }

    public void mouseDragged(int x, int y) {
        if (!this.touch || this.drag) {
            this.mouseMove(x, y);
        }
    }

    public void mousePressed(int x, int y, MouseListener.MouseButton button) {
        if (!this.touch || button == MouseListener.MouseButton.FIRST_BUTTON) {
            this.mousePress(x, y, button);
            this.drag = true;
        }
    }

    public void mouseReleased(int x, int y, MouseListener.MouseButton button) {
        if (!this.touch || button == MouseListener.MouseButton.FIRST_BUTTON) {
            this.mouseRelease(x, y, button);
            this.drag = false;
        }
    }

    protected PointerListener getListener() {
        return this.listener;
    }

    protected boolean isTouch() {
        return this.touch;
    }

    protected int getMoveFilteringDelay() {
        return 20;
    }

    private int updatePointerX(int x) {
        x *= this.areaWidth;
        return x /= this.getWidth();
    }

    private int updatePointerY(int y) {
        y *= this.areaHeight;
        return y /= this.getHeight();
    }

    private void mouseMove(int x, int y) {
        if (System.currentTimeMillis() - this.lastEventTime > (long)this.getMoveFilteringDelay()) {
            this.listener.move(this, this.updatePointerX(x), this.updatePointerY(y));
            this.lastEventTime = System.currentTimeMillis();
        }
    }

    private void mousePress(int x, int y, MouseListener.MouseButton button) {
        this.listener.press(this, this.updatePointerX(x), this.updatePointerY(y), button);
        this.lastEventTime = System.currentTimeMillis();
    }

    private void mouseRelease(int x, int y, MouseListener.MouseButton button) {
        this.listener.release(this, button);
    }

    public static interface PointerListener {
        public void press(Pointer var1, int var2, int var3, MouseListener.MouseButton var4);

        public void release(Pointer var1, MouseListener.MouseButton var2);

        public void move(Pointer var1, int var2, int var3);
    }

    public static class PointerListenerToPointerEvents
    implements PointerListener {
        @Override
        public void move(Pointer widget, int x, int y) {
            EventTouch.sendMovedEvent((String)this.getMicroUIGeneratorTag(widget), (int)x, (int)y);
        }

        @Override
        public void press(Pointer widget, int x, int y, MouseListener.MouseButton button) {
            EventTouch.sendPressedEvent((String)this.getMicroUIGeneratorTag(widget), (int)x, (int)y);
        }

        @Override
        public void release(Pointer widget, MouseListener.MouseButton button) {
            EventTouch.sendReleasedEvent((String)this.getMicroUIGeneratorTag(widget));
        }

        protected String getMicroUIGeneratorTag(Pointer widget) {
            return widget.isTouch() ? "TOUCH" : "POINTER";
        }
    }
}

