/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth;

public class HexTools {
    private static final char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexTools() {
    }

    public static void byteToString(byte b, char[] string, int stringIndex) {
        int value = b & 0xFF;
        string[stringIndex + 0] = HEX_TABLE[value >> 4];
        string[stringIndex + 1] = HEX_TABLE[value & 0xF];
    }

    public static byte stringToByte(String string, int stringIndex) {
        char c0 = string.charAt(stringIndex);
        char c1 = string.charAt(stringIndex + 1);
        return (byte)(HexTools.getHexValue(c0) << 4 | HexTools.getHexValue(c1));
    }

    private static int getHexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException();
    }
}

