/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

public class Dock
extends Container {
    private DockedWidget[] dockedWidgets = new DockedWidget[0];
    @Nullable
    private Widget centerWidget;

    private void addChild(Widget widget, int position) {
        this.dockedWidgets = (DockedWidget[])ArrayTools.add((Object[])this.dockedWidgets, (Object)new DockedWidget(widget, position));
        this.addChild(widget);
    }

    public void addChildOnLeft(Widget child) {
        this.addChild(child, 3);
    }

    public void addChildOnRight(Widget child) {
        this.addChild(child, 4);
    }

    public void addChildOnTop(Widget child) {
        this.addChild(child, 1);
    }

    public void addChildOnBottom(Widget child) {
        this.addChild(child, 2);
    }

    public void setCenterChild(Widget child) {
        Widget centerWidget = this.centerWidget;
        if (centerWidget != null) {
            this.removeChild(centerWidget);
        }
        this.centerWidget = child;
        this.addChild(child);
    }

    @Nullable
    public Widget getCenterChild() {
        return this.centerWidget;
    }

    public void removeChild(Widget child) {
        if (child == this.centerWidget) {
            this.centerWidget = null;
        } else {
            Object[] dockedWidgets;
            Object[] objectArray = dockedWidgets = this.dockedWidgets;
            int n = dockedWidgets.length;
            int n2 = 0;
            while (n2 < n) {
                DockedWidget dockedWidget = objectArray[n2];
                if (dockedWidget.widget == child) {
                    this.dockedWidgets = (DockedWidget[])ArrayTools.remove((Object[])dockedWidgets, (Object)dockedWidget);
                    break;
                }
                ++n2;
            }
        }
        super.removeChild(child);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.dockedWidgets = new DockedWidget[0];
        this.centerWidget = null;
    }

    protected void computeContentOptimalSize(Size size) {
        DockedWidget[] dockedWidgets;
        int widthHint = size.getWidth();
        int heightHint = size.getHeight();
        int remainingWidth = widthHint;
        int remainingHeight = heightHint;
        DockedWidget[] dockedWidgetArray = dockedWidgets = this.dockedWidgets;
        int n = dockedWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            DockedWidget dockedWidget = dockedWidgetArray[n2];
            Widget widget = dockedWidget.widget;
            this.computeChildOptimalSize(widget, remainingWidth, remainingHeight);
            if (dockedWidget.isHorizontal()) {
                if (widthHint != 0) {
                    remainingWidth = Math.max(0, remainingWidth - widget.getWidth());
                }
            } else if (heightHint != 0) {
                remainingHeight = Math.max(0, remainingHeight - widget.getHeight());
            }
            ++n2;
        }
        int totalWidth = 0;
        int totalHeight = 0;
        Widget center = this.centerWidget;
        if (center != null) {
            this.computeChildOptimalSize(center, remainingWidth, remainingHeight);
            totalWidth += center.getWidth();
            totalHeight += center.getHeight();
        }
        int i = dockedWidgets.length - 1;
        while (i >= 0) {
            DockedWidget dockedWidget = dockedWidgets[i];
            Widget widget = dockedWidget.widget;
            int widgetWidth = widget.getWidth();
            int widgetHeight = widget.getHeight();
            if (dockedWidget.isHorizontal()) {
                totalWidth += widgetWidth;
                totalHeight = Math.max(totalHeight, widgetHeight);
            } else {
                totalWidth = Math.max(totalWidth, widgetWidth);
                totalHeight += widgetHeight;
            }
            --i;
        }
        size.setSize(totalWidth, totalHeight);
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        int x = 0;
        int y = 0;
        DockedWidget[] dockedWidgetArray = this.dockedWidgets;
        int n = this.dockedWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            DockedWidget dockedWidget = dockedWidgetArray[n2];
            Widget widget = dockedWidget.widget;
            int widgetWidth = widget.getWidth();
            int widgetHeight = widget.getHeight();
            switch (dockedWidget.position) {
                case 3: {
                    this.layOutChild(widget, x, y, widgetWidth, contentHeight);
                    x += widgetWidth;
                    contentWidth -= widgetWidth;
                    break;
                }
                case 4: {
                    this.layOutChild(widget, x + contentWidth - widgetWidth, y, widgetWidth, contentHeight);
                    contentWidth -= widgetWidth;
                    break;
                }
                case 1: {
                    this.layOutChild(widget, x, y, contentWidth, widgetHeight);
                    y += widgetHeight;
                    contentHeight -= widgetHeight;
                    break;
                }
                case 2: {
                    this.layOutChild(widget, x, y + contentHeight - widgetHeight, contentWidth, widgetHeight);
                    contentHeight -= widgetHeight;
                }
            }
            ++n2;
        }
        Widget center = this.centerWidget;
        if (center != null) {
            this.layOutChild(center, x, y, contentWidth, contentHeight);
        }
    }

    private static class DockedWidget {
        private static final int POSITION_TOP = 1;
        private static final int POSITION_BOTTOM = 2;
        private static final int POSITION_LEFT = 3;
        private static final int POSITION_RIGHT = 4;
        private final Widget widget;
        private final int position;

        private DockedWidget(Widget widget, int position) {
            this.widget = widget;
            this.position = position;
        }

        private boolean isHorizontal() {
            return this.position == 3 || this.position == 4;
        }
    }
}

