/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.render;

import ej.microui.display.Display;
import ej.microui.display.GraphicsContext;
import ej.mwt.Container;
import ej.mwt.Desktop;
import ej.mwt.Widget;
import ej.mwt.render.DefaultRenderPolicy;

public class OverlapRenderPolicy
extends DefaultRenderPolicy {
    public OverlapRenderPolicy(Desktop desktop) {
        super(desktop);
    }

    @Override
    protected void renderWidget(Widget widget, int x, int y, int width, int height) {
        GraphicsContext g = Display.getDisplay().getGraphicsContext();
        g.resetTranslation();
        g.resetClip();
        this.setParentClip(widget, g);
        g.intersectClip(widget.getX() + x, widget.getY() + y, width, height);
        int translateX = g.getTranslationX();
        int translateY = g.getTranslationY();
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        this.getDesktop().renderWidget(g, widget);
        this.renderSiblings(g, widget, translateX, translateY, clipX, clipY, clipWidth, clipHeight);
    }

    private void renderSiblings(GraphicsContext g, Widget widget, int translateX, int translateY, int clipX, int clipY, int clipWidth, int clipHeight) {
        Container parent = widget.getParent();
        if (parent != null) {
            int childIndex = parent.getChildIndex(widget);
            int length = parent.getChildrenCount();
            int i = childIndex + 1;
            while (i < length) {
                Widget child = parent.getChild(i);
                assert (child != null);
                if (child.isShown()) {
                    g.setTranslation(translateX, translateY);
                    g.setClip(clipX, clipY, clipWidth, clipHeight);
                    this.getDesktop().renderWidget(g, child);
                }
                ++i;
            }
            int parentX = parent.getX() + parent.getContentX();
            int parentY = parent.getY() + parent.getContentY();
            this.renderSiblings(g, parent, translateX - parentX, translateY - parentY, clipX + parentX, clipY + parentY, clipWidth, clipHeight);
        }
    }
}

