/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothConnection;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class SendWriteRequestEndpoint
implements Endpoint {
    private final BluetoothController controller;
    private short connHandle;
    private short attributeHandle;
    @Nullable
    private byte[] value;
    private boolean noResponse;

    public SendWriteRequestEndpoint(BluetoothController controller) {
        this.controller = controller;
    }

    public String getName() {
        return "bluetooth_send_write_request";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.connHandle = (short)reader.readInt();
        this.attributeHandle = (short)reader.readInt();
        this.value = reader.readByteArray();
        this.noResponse = reader.readBoolean();
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        BluetoothConnection connection = this.controller.getConnection(this.connHandle);
        BluetoothAttribute attribute = this.controller.getRemoteAttribute(connection, this.attributeHandle);
        assert (this.value != null);
        if (connection != null && attribute != null && connection.sendWriteRequest(attribute, this.value)) {
            sender.sendInt(0);
        } else {
            sender.sendInt(1);
        }
    }
}

