/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.BluetoothServiceDefinition;
import ej.bluetooth.BluetoothUuid;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class AddServiceEndpoint
implements Endpoint {
    private static final byte ATTRIBUTE_TYPE_CHARACTERISTIC = 0;
    private static final byte ATTRIBUTE_TYPE_DESCRIPTOR = 1;
    private static final int SERVICE_HEADER_SIZE = 18;
    private static final int ATTRIBUTE_SIZE = 20;
    private final BluetoothController controller;
    @Nullable
    private byte[] service;

    public AddServiceEndpoint(BluetoothController controller) {
        this.controller = controller;
    }

    public String getName() {
        return "bluetooth_add_service";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.service = reader.readByteArray();
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        byte[] service = this.service;
        assert (service != null);
        int numHandles = 1 + service[16] + service[17];
        short[] handles = new short[numHandles];
        BluetoothServiceDefinition serviceDefinition = this.createServiceDefinition();
        BluetoothService addedService = BluetoothAdapter.getAdapter().addService(serviceDefinition);
        if (addedService != null) {
            this.controller.onServiceAdded(addedService, handles);
        }
        byte[] handlesByteArray = new byte[numHandles * 2];
        int i = 0;
        while (i < numHandles) {
            handlesByteArray[i * 2] = (byte)(handles[i] >> 8);
            handlesByteArray[i * 2 + 1] = (byte)handles[i];
            ++i;
        }
        sender.sendInt(addedService != null ? 0 : 1);
        sender.sendByteArray(handlesByteArray, 0, numHandles * 2);
    }

    private BluetoothServiceDefinition createServiceDefinition() {
        byte[] service = this.service;
        assert (service != null);
        BluetoothUuid serviceUuid = new BluetoothUuid(service, 0);
        BluetoothServiceDefinition definition = new BluetoothServiceDefinition(serviceUuid);
        int attrOffset = 18;
        while (attrOffset < service.length) {
            byte attrType = service[attrOffset];
            BluetoothUuid attrUuid = new BluetoothUuid(service, attrOffset + 2);
            byte attrPermissions = service[attrOffset + 18];
            byte attrProperties = service[attrOffset + 19];
            attrOffset += 20;
            if (attrType == 0) {
                definition.addCharacteristic(attrUuid, (int)attrProperties, (int)attrPermissions);
                continue;
            }
            if (attrType != 1) continue;
            definition.addDescriptor(attrUuid, (int)attrPermissions);
        }
        return definition;
    }
}

