/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBufferR;

class HeapFloatBuffer
extends FloatBuffer {
    HeapFloatBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new float[cap], 0);
    }

    HeapFloatBuffer(float[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapFloatBuffer(float[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public FloatBuffer slice() {
        float[] hb = this.hb;
        assert (hb != null);
        return new HeapFloatBuffer(hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public FloatBuffer duplicate() {
        float[] hb = this.hb;
        assert (hb != null);
        return new HeapFloatBuffer(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        float[] hb = this.hb;
        assert (hb != null);
        return new HeapFloatBufferR(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public float get() {
        float[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public float get(int i) {
        float[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public FloatBuffer get(float[] dst, int offset, int length) {
        HeapFloatBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        float[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FloatBuffer put(float x) {
        float[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public FloatBuffer put(int i, float x) {
        float[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public FloatBuffer put(float[] src, int offset, int length) {
        HeapFloatBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        float[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(src, offset, hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public FloatBuffer put(FloatBuffer src) {
        float[] hb = this.hb;
        assert (hb != null);
        if (src instanceof HeapFloatBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapFloatBuffer sb = (HeapFloatBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            float[] srcHb = sb.hb;
            assert (srcHb != null);
            System.arraycopy(srcHb, sb.ix(sb.position()), hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public FloatBuffer compact() {
        float[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

