/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBufferR;

class HeapCharBuffer
extends CharBuffer {
    HeapCharBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new char[cap], 0);
    }

    HeapCharBuffer(char[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapCharBuffer(char[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public CharBuffer slice() {
        char[] hb = this.hb;
        assert (hb != null);
        return new HeapCharBuffer(hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public CharBuffer duplicate() {
        char[] hb = this.hb;
        assert (hb != null);
        return new HeapCharBuffer(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        char[] hb = this.hb;
        assert (hb != null);
        return new HeapCharBufferR(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public char get() {
        char[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public char get(int i) {
        char[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public CharBuffer get(char[] dst, int offset, int length) {
        HeapCharBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        char[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public CharBuffer put(char x) {
        char[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public CharBuffer put(int i, char x) {
        char[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        HeapCharBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        char[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(src, offset, hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public CharBuffer put(CharBuffer src) {
        char[] hb = this.hb;
        assert (hb != null);
        if (src instanceof HeapCharBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapCharBuffer sb = (HeapCharBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            char[] srcHb = sb.hb;
            assert (srcHb != null);
            System.arraycopy(srcHb, sb.ix(sb.position()), hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public CharBuffer compact() {
        char[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    String toString(int start, int end) {
        try {
            char[] hb = this.hb;
            assert (hb != null);
            return new String(hb, start + this.offset, end - start);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        if (start < 0 || end > this.length() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        int pos = this.position();
        char[] hb = this.hb;
        assert (hb != null);
        return new HeapCharBuffer(hb, -1, pos + start, pos + end, this.capacity(), this.offset);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

