/*
 * Decompiled with CFR 0.152.
 */
package ej.json;

import ej.json.JSONException;
import java.io.IOException;
import java.io.OutputStream;

public class JSONWriter {
    private static final int maxdepth = 20;
    private static final int ERROR_NULL_POINTER = 0;
    private static final int ERROR_VALUE_OUT_OF_SEQUENCE = 1;
    private static final int ERROR_MISPLACED_ARRAY = 2;
    private static final int ERROR_MISPLACED_ENDOBJECT = 3;
    private static final int ERROR_MISPLACED_ENDARRAY = 4;
    private static final int ERROR_NULL_KEY = 5;
    private static final int ERROR_MISPLACED_KEY = 6;
    private static final int ERROR_MISPLACED_OBJECT = 7;
    private static final int ERROR_NESTING_ERROR = 8;
    private static final int ERROR_NESTING_TOO_DEEP = 9;
    private static final int ERROR_NON_FINITE_NUMBERS = 10;
    private boolean comma = false;
    protected char mode = (char)105;
    private final char[] stack = new char[20];
    private int top = 0;
    protected OutputStream os;

    public JSONWriter(OutputStream os) {
        this.os = os;
    }

    private JSONWriter append(String s) throws JSONException {
        if (s == null) {
            throw this.error(0);
        }
        if (this.mode == 'o' || this.mode == 'a' || this.mode == 'i') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.os.write(44);
                }
                this.os.write(s.getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            } else if (this.mode == 'i') {
                this.mode = (char)100;
            }
            this.comma = true;
            return this;
        }
        throw this.error(1);
    }

    public JSONWriter array() throws JSONException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            return this;
        }
        throw this.error(2);
    }

    private JSONWriter end(char m, char c) throws JSONException {
        if (this.mode != m) {
            throw this.error(m == 'o' ? 3 : 4);
        }
        this.pop(m);
        try {
            this.os.write(c);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() throws JSONException {
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws JSONException {
        return this.end('k', '}');
    }

    public JSONWriter key(String s) throws JSONException {
        if (s == null) {
            throw this.error(5);
        }
        if (this.mode == 'k') {
            try {
                if (this.comma) {
                    this.os.write(44);
                }
                this.os.write(JSONWriter.quote(s).getBytes("UTF-8"));
                this.os.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        throw this.error(6);
    }

    public JSONWriter object() throws JSONException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            return this;
        }
        throw this.error(7);
    }

    private void pop(char c) throws JSONException {
        if (this.top <= 0 || this.stack[this.top - 1] != c) {
            throw this.error(8);
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c) throws JSONException {
        if (this.top >= 20) {
            throw this.error(9);
        }
        this.stack[this.top] = c;
        this.mode = c;
        ++this.top;
    }

    public JSONWriter value(boolean b) throws JSONException {
        return this.append(b ? "true" : "false");
    }

    public JSONWriter value(double d) throws JSONException {
        if (Double.valueOf(d).isInfinite() || Double.valueOf(d).isNaN()) {
            throw this.error(10);
        }
        return this.append(JSONWriter.trimNumber(Double.toString(d)));
    }

    private static String trimNumber(String s) {
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public JSONWriter value(long l) throws JSONException {
        return this.append(Long.toString(l));
    }

    public JSONWriter value(String s) throws JSONException {
        return this.append(JSONWriter.quote(s));
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private JSONException error(int code) {
        return new JSONException("E=" + code);
    }
}

