/*
 * Decompiled with CFR 0.152.
 */
package ej.jsonpath.parser;

import ej.jsonpath.parser.CharStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class SimpleCharStream
implements CharStream {
    private static final int DEFAULT_BUFFER_SIZE = Integer.parseInt(System.getProperty("ej.rest.jsonquerypath.buffersize", "128"));
    private static final int EXPAND_BUFFER_SIZE = Integer.parseInt(System.getProperty("ej.rest.jsonquerypath.expandbuffersize", "32"));
    int bufsize;
    int available;
    int tokenBegin;
    public int bufpos = -1;
    protected int[] bufline;
    protected int[] bufcolumn;
    protected int column = 0;
    protected int line = 1;
    protected boolean prevCharIsCR = false;
    protected boolean prevCharIsLF = false;
    protected Reader inputStream;
    protected char[] buffer;
    protected int maxNextCharInd = 0;
    protected int inBuf = 0;
    protected int tabSize = 1;
    protected boolean trackLineColumn = true;

    @Override
    public void setTabSize(int i) {
        this.tabSize = i;
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }

    protected void ExpandBuff(boolean wrapAround) {
        int bufsize = this.bufsize;
        int newBufsize = bufsize + EXPAND_BUFFER_SIZE;
        char[] newbuffer = new char[newBufsize];
        int[] newbufline = new int[newBufsize];
        int[] newbufcolumn = new int[newBufsize];
        try {
            char[] buffer = this.buffer;
            int tokenBegin = this.tokenBegin;
            int[] bufline = this.bufline;
            int[] bufcolumn = this.bufcolumn;
            if (wrapAround) {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                int bufpos = this.bufpos;
                System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
                this.buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
                this.bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
                this.bufcolumn = newbufcolumn;
                this.maxNextCharInd = this.bufpos += bufsize - tokenBegin;
            } else {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                this.buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                this.bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                this.bufcolumn = newbufcolumn;
                this.maxNextCharInd = this.bufpos -= tokenBegin;
            }
        }
        catch (Throwable t) {
            throw new Error(t.getMessage());
        }
        this.bufsize += 2048;
        this.available = bufsize;
        this.tokenBegin = 0;
    }

    protected void FillBuff() throws IOException {
        int tokenBegin = this.tokenBegin;
        int available = this.available;
        if (this.maxNextCharInd == available) {
            if (available == this.bufsize) {
                if (tokenBegin > EXPAND_BUFFER_SIZE) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                    this.available = tokenBegin;
                } else if (tokenBegin < 0) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                } else {
                    this.ExpandBuff(false);
                }
            } else if (available > tokenBegin) {
                this.available = this.bufsize;
            } else if (tokenBegin - available < EXPAND_BUFFER_SIZE) {
                this.ExpandBuff(true);
            } else {
                this.available = tokenBegin;
            }
        }
        available = this.available;
        try {
            int i = this.inputStream.read(this.buffer, this.maxNextCharInd, available - this.maxNextCharInd);
            if (i == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += i;
            return;
        }
        catch (IOException e) {
            --this.bufpos;
            this.backup(0);
            if (tokenBegin == -1) {
                this.tokenBegin = this.bufpos;
            }
            throw e;
        }
    }

    @Override
    public char BeginToken() throws IOException {
        this.tokenBegin = -1;
        char c = this.readChar();
        this.tokenBegin = this.bufpos;
        return c;
    }

    protected void UpdateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += this.tabSize - this.column % this.tabSize;
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    @Override
    public char readChar() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        if (++this.bufpos >= this.maxNextCharInd) {
            this.FillBuff();
        }
        char c = this.buffer[this.bufpos];
        this.UpdateLineColumn(c);
        return c;
    }

    @Override
    @Deprecated
    public int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    @Override
    @Deprecated
    public int getLine() {
        return this.bufline[this.bufpos];
    }

    @Override
    public int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    @Override
    public int getEndLine() {
        return this.bufline[this.bufpos];
    }

    @Override
    public int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    @Override
    public int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    @Override
    public void backup(int amount) {
        this.inBuf += amount;
        if ((this.bufpos -= amount) < 0) {
            this.bufpos += this.bufsize;
        }
    }

    public SimpleCharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.inputStream = dstream;
        this.line = startline;
        this.column = startcolumn - 1;
        this.available = this.bufsize = buffersize;
        this.buffer = new char[buffersize];
        this.bufline = new int[buffersize];
        this.bufcolumn = new int[buffersize];
    }

    public SimpleCharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, DEFAULT_BUFFER_SIZE);
    }

    public SimpleCharStream(Reader dstream) {
        this(dstream, 1, 1, DEFAULT_BUFFER_SIZE);
    }

    public void ReInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.inputStream = dstream;
        this.line = startline;
        this.column = startcolumn - 1;
        if (this.buffer == null || buffersize != this.buffer.length) {
            this.available = this.bufsize = buffersize;
            this.buffer = new char[buffersize];
            this.bufline = new int[buffersize];
            this.bufcolumn = new int[buffersize];
        }
        this.prevCharIsCR = false;
        this.prevCharIsLF = false;
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.tokenBegin = 0;
        this.bufpos = -1;
    }

    public void ReInit(Reader dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, DEFAULT_BUFFER_SIZE);
    }

    public void ReInit(Reader dstream) {
        this.ReInit(dstream, 1, 1, DEFAULT_BUFFER_SIZE);
    }

    public SimpleCharStream(InputStream dstream, String encoding, int startline, int startcolumn, int buffersize) throws UnsupportedEncodingException {
        this(encoding == null ? new InputStreamReader(dstream) : new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    public SimpleCharStream(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this(new InputStreamReader(dstream), startline, startcolumn, buffersize);
    }

    public SimpleCharStream(InputStream dstream, String encoding, int startline, int startcolumn) throws UnsupportedEncodingException {
        this(dstream, encoding, startline, startcolumn, DEFAULT_BUFFER_SIZE);
    }

    public SimpleCharStream(InputStream dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, DEFAULT_BUFFER_SIZE);
    }

    public SimpleCharStream(InputStream dstream, String encoding) throws UnsupportedEncodingException {
        this(dstream, encoding, 1, 1, DEFAULT_BUFFER_SIZE);
    }

    public SimpleCharStream(InputStream dstream) {
        this(dstream, 1, 1, DEFAULT_BUFFER_SIZE);
    }

    public void ReInit(InputStream dstream, String encoding, int startline, int startcolumn, int buffersize) throws UnsupportedEncodingException {
        this.ReInit(encoding == null ? new InputStreamReader(dstream) : new InputStreamReader(dstream, encoding), startline, startcolumn, buffersize);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this.ReInit(new InputStreamReader(dstream), startline, startcolumn, buffersize);
    }

    public void ReInit(InputStream dstream, String encoding) throws UnsupportedEncodingException {
        this.ReInit(dstream, encoding, 1, 1, DEFAULT_BUFFER_SIZE);
    }

    public void ReInit(InputStream dstream) {
        this.ReInit(dstream, 1, 1, DEFAULT_BUFFER_SIZE);
    }

    public void ReInit(InputStream dstream, String encoding, int startline, int startcolumn) throws UnsupportedEncodingException {
        this.ReInit(dstream, encoding, startline, startcolumn, DEFAULT_BUFFER_SIZE);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, DEFAULT_BUFFER_SIZE);
    }

    @Override
    public String GetImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return String.valueOf(new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin)) + new String(this.buffer, 0, this.bufpos + 1);
    }

    @Override
    public char[] GetSuffix(int len) {
        char[] ret = new char[len];
        if (this.bufpos + 1 >= len) {
            System.arraycopy(this.buffer, this.bufpos - len + 1, ret, 0, len);
        } else {
            System.arraycopy(this.buffer, this.bufsize - (len - this.bufpos - 1), ret, 0, len - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, ret, len - this.bufpos - 1, this.bufpos + 1);
        }
        return ret;
    }

    @Override
    public void Done() {
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
    }

    public void adjustBeginLineColumn(int newLine, int newCol) {
        int tokenBegin;
        int start = tokenBegin = this.tokenBegin;
        int bufsize = this.bufsize;
        int bufpos = this.bufpos;
        int inBuf = this.inBuf;
        int len = bufpos >= tokenBegin ? bufpos - tokenBegin + inBuf + 1 : bufsize - tokenBegin + bufpos + 1 + inBuf;
        int i = 0;
        int j = 0;
        int k = 0;
        int nextColDiff = 0;
        int columnDiff = 0;
        int[] bufline = this.bufline;
        int[] bufcolumn = this.bufcolumn;
        while (i < len && bufline[j = start % bufsize] == bufline[k = ++start % bufsize]) {
            bufline[j] = newLine;
            nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
            bufcolumn[j] = newCol + columnDiff;
            columnDiff = nextColDiff;
            ++i;
        }
        if (i < len) {
            bufline[j] = newLine++;
            bufcolumn[j] = newCol + columnDiff;
            while (i++ < len) {
                j = start % bufsize;
                bufline[j] = bufline[j] != bufline[++start % bufsize] ? newLine++ : newLine;
            }
        }
        this.line = bufline[j];
        this.column = bufcolumn[j];
    }

    @Override
    public boolean getTrackLineColumn() {
        return this.trackLineColumn;
    }

    @Override
    public void setTrackLineColumn(boolean tlc) {
        this.trackLineColumn = tlc;
    }
}

