/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

class StringCharBuffer
extends CharBuffer {
    CharSequence str;

    StringCharBuffer(CharSequence s, int start, int end) {
        super(-1, start, end, s.length());
        int n = s.length();
        if (start < 0 || start > n || end < start || end > n) {
            throw new IndexOutOfBoundsException();
        }
        this.str = s;
    }

    @Override
    public CharBuffer slice() {
        return new StringCharBuffer(this.str, -1, 0, this.remaining(), this.remaining(), this.offset + this.position());
    }

    private StringCharBuffer(CharSequence s, int mark, int pos, int limit, int cap, int offset) {
        super(mark, pos, limit, cap, null, offset);
        this.str = s;
    }

    @Override
    public CharBuffer duplicate() {
        return new StringCharBuffer(this.str, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public final char get() {
        return this.str.charAt(this.nextGetIndex() + this.offset);
    }

    @Override
    public final char get(int index) {
        return this.str.charAt(this.checkIndex(index) + this.offset);
    }

    char getUnchecked(int index) {
        return this.str.charAt(index + this.offset);
    }

    @Override
    public final CharBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final CharBuffer put(int index, char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    final String toString(int start, int end) {
        return this.str.toString().substring(start + this.offset, end + this.offset);
    }

    @Override
    public final CharBuffer subSequence(int start, int end) {
        try {
            int pos = this.position();
            return new StringCharBuffer(this.str, -1, pos + this.checkIndex(start, pos), pos + this.checkIndex(end, pos), this.capacity(), this.offset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

