/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import ej.microvg.image.ImageGenerator;
import ej.microvg.image.LinearGradient;
import ej.microvg.image.MatrixHelper;
import ej.microvg.image.Path;
import ej.microvg.image.pathdata.SingleArrayPathData;
import ej.microvg.image.pathdata.SingleArrayPathDataFP32;
import ej.microvg.image.pathdata.SingleArrayPathDataS16;
import ej.microvg.image.pathdata.SingleArrayPathDataS32;
import ej.microvg.image.pathdata.SingleArrayPathDataS8;
import java.awt.Color;
import java.nio.ByteBuffer;

public class VgliteImageGenerator
implements ImageGenerator {
    private static final int VG_LITE_S8 = 0;
    private static final int VG_LITE_S16 = 1;
    private static final int VG_LITE_S32 = 2;
    private static final int VG_LITE_FP32 = 3;
    private static final int CMD_CLOSE = 0;
    private static final int CMD_MOVE = 2;
    private static final int CMD_MOVE_REL = 3;
    private static final int CMD_LINE = 4;
    private static final int CMD_LINE_REL = 5;
    private static final int CMD_QUAD = 6;
    private static final int CMD_QUAD_REL = 7;
    private static final int CMD_CUBIC = 8;
    private static final int CMD_CUBIC_REL = 9;
    private static final float GRADIENT_SMALL_LENGTH = 0.1f;
    private static final int GRADIENT_MAX_STOPS = 255;
    private static final int GRADIENT_SCALE_NONE = 1;
    private static final int GRADIENT_VLC_MAX_GRAD = 16;
    private static final int MAX_GRADIENT_STOP_COUNT = 16;
    private static final int GRADIENT_OFFSET_COLORS_SIZE = 0;
    private static final int GRADIENT_OFFSET_XSTART = 1;
    private static final int GRADIENT_OFFSET_YSTART = 2;
    private static final int GRADIENT_OFFSET_ANGLE = 3;
    private static final int GRADIENT_OFFSET_LENGTH = 4;
    private static final int GRADIENT_OFFSET_COLORS_OFFSET = 5;
    private static final int GRADIENT_OFFSET_POSITION_OFFSET = 6;
    private static final int GRADIENT_HEADER_SIZE = 7;
    private static final int SIZE_VGLITE_GRADIENT = 168;
    private final SingleArrayPathData pathData;

    public VgliteImageGenerator(ImageGenerator.Format format) {
        this.pathData = VgliteImageGenerator.newPathData(format);
    }

    @Override
    public int encodeCommand(ImageGenerator.Command command) {
        switch (command) {
            default: {
                return 0;
            }
            case COMMAND_MOVE: {
                return 2;
            }
            case COMMAND_MOVE_REL: {
                return 3;
            }
            case COMMAND_LINE: {
                return 4;
            }
            case COMMAND_LINE_REL: {
                return 5;
            }
            case COMMAND_QUAD: {
                return 6;
            }
            case COMMAND_QUAD_REL: {
                return 7;
            }
            case COMMAND_CUBIC: {
                return 8;
            }
            case COMMAND_CUBIC_REL: 
        }
        return 9;
    }

    @Override
    public int encodeColor(Color color, float opacity) {
        int newColor = 0;
        newColor |= color.getRed() << 16;
        newColor |= color.getGreen() << 8;
        newColor |= color.getBlue();
        return newColor |= (int)(opacity * 255.0f) << 24;
    }

    @Override
    public byte[] encodePath(Path path) {
        SingleArrayPathData pathData = this.pathData;
        path.encode(pathData);
        byte[] data = pathData.getPath();
        int size = 24 + data.length;
        ByteBuffer buffer = this.newByteBuffer(size);
        buffer.putFloat((float)path.getMinX());
        buffer.putFloat((float)path.getMinY());
        buffer.putFloat((float)path.getMaxX());
        buffer.putFloat((float)path.getMaxY());
        buffer.putInt(data.length);
        buffer.put((byte)VgliteImageGenerator.convertFormat(pathData.getFormat()));
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put(data);
        return buffer.array();
    }

    private static SingleArrayPathData newPathData(ImageGenerator.Format outputFormat) {
        switch (outputFormat) {
            case VG_S8: {
                return new SingleArrayPathDataS8();
            }
            case VG_S16: {
                return new SingleArrayPathDataS16();
            }
            case VG_S32: {
                return new SingleArrayPathDataS32();
            }
        }
        return new SingleArrayPathDataFP32();
    }

    public static int convertFormat(ImageGenerator.Format format) {
        switch (format) {
            case VG_S8: {
                return 0;
            }
            case VG_S16: {
                return 1;
            }
            case VG_S32: {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public byte[] encodeGradient(LinearGradient gradient) {
        ByteBuffer buffer = this.newByteBuffer(168);
        int[] gradientHeader = VgliteImageGenerator.getHeader(gradient);
        LinearGradient.LinearGradientStop[] gradientStops = gradient.getStops();
        int padding = 16 - gradientStops.length;
        LinearGradient.LinearGradientStop[] linearGradientStopArray = gradientStops;
        int n = gradientStops.length;
        int n2 = 0;
        while (n2 < n) {
            LinearGradient.LinearGradientStop gradientStop = linearGradientStopArray[n2];
            buffer.putInt(this.encodeColor(gradientStop.getColor(), gradientStop.getOpacity()));
            ++n2;
        }
        int i = padding;
        while (--i >= 0) {
            buffer.putInt(0);
        }
        buffer.putInt(gradientStops.length);
        linearGradientStopArray = gradientStops;
        n = gradientStops.length;
        n2 = 0;
        while (n2 < n) {
            LinearGradient.LinearGradientStop gradientStop = linearGradientStopArray[n2];
            buffer.putInt((int)(gradientStop.getPosition() * 255.0f));
            ++n2;
        }
        i = padding;
        while (--i >= 0) {
            buffer.putInt(0);
        }
        float[] localMatrix = MatrixHelper.createIdentity();
        MatrixHelper.translate(localMatrix, Float.intBitsToFloat(gradientHeader[1]), Float.intBitsToFloat(gradientHeader[2]));
        MatrixHelper.rotate(localMatrix, Float.intBitsToFloat(gradientHeader[3]));
        float length = Float.intBitsToFloat(gradientHeader[4]);
        if (length == 0.0f) {
            length = 0.1f;
        }
        MatrixHelper.scale(localMatrix, length / this.getGradientScaleSize(), 1.0f);
        float[] fArray = localMatrix;
        int n3 = localMatrix.length;
        int n4 = 0;
        while (n4 < n3) {
            float elem = fArray[n4];
            buffer.putFloat(elem);
            ++n4;
        }
        return buffer.array();
    }

    private float getGradientScaleSize() {
        return 256.0f;
    }

    private static int[] getHeader(LinearGradient svgGradient) {
        float x1 = svgGradient.getXStart();
        float y1 = svgGradient.getYStart();
        float x2 = svgGradient.getXEnd();
        float y2 = svgGradient.getYEnd();
        float length = (float)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        float angle = (float)Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
        LinearGradient.LinearGradientStop[] gradientStops = svgGradient.getStops();
        int count = gradientStops.length;
        if (count > 16) {
            throw new IllegalArgumentException("The number of stops(" + count + ") for gradient ([" + x1 + "," + y1 + "]->[" + x2 + "," + y2 + "]) exceed maximum VGLite value(" + 16 + ")");
        }
        int[] header = new int[]{count, Float.floatToRawIntBits(x1), Float.floatToRawIntBits(y1), Float.floatToRawIntBits(angle), Float.floatToRawIntBits(length), 7, 7 + count};
        return header;
    }
}

