/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.stylesheet.cascading;

import ej.annotation.Nullable;
import ej.microui.display.Font;
import ej.mwt.style.EditableStyle;
import ej.mwt.style.Style;
import ej.mwt.style.background.Background;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.outline.Outline;

class CascadingStyle
extends EditableStyle {
    private static final int DIMENSION_SHIFT = 0;
    private static final int HORIZONTAL_ALIGNMENT_SHIFT = 1;
    private static final int VERTICAL_ALIGNMENT_SHIFT = 2;
    private static final int MARGIN_SHIFT = 3;
    private static final int BORDER_SHIFT = 4;
    private static final int PADDING_SHIFT = 5;
    private static final int BACKGROUND_SHIFT = 6;
    private static final int COLOR_SHIFT = 7;
    private static final int FONT_SHIFT = 8;
    private static final int EXTRA_FIELDS_SHIFT = 9;
    private static final int INHERIT_MASK = 386;
    private static final int EXTRA_FIELDS_MAP = -512;
    private short map;
    private short hashCode;

    CascadingStyle() {
    }

    CascadingStyle(EditableStyle style) {
        super(style);
    }

    @Override
    public void setDimension(Dimension dimension) {
        super.setDimension(dimension);
        this.map = (short)(this.map | 1);
    }

    @Override
    public void setHorizontalAlignment(int horizontalAlignment) {
        super.setHorizontalAlignment(horizontalAlignment);
        this.map = (short)(this.map | 2);
    }

    @Override
    public void setVerticalAlignment(int verticalAlignment) {
        super.setVerticalAlignment(verticalAlignment);
        this.map = (short)(this.map | 4);
    }

    @Override
    public void setMargin(Outline margin) {
        super.setMargin(margin);
        this.map = (short)(this.map | 8);
    }

    @Override
    public void setBorder(Outline border) {
        super.setBorder(border);
        this.map = (short)(this.map | 0x10);
    }

    @Override
    public void setPadding(Outline padding) {
        super.setPadding(padding);
        this.map = (short)(this.map | 0x20);
    }

    @Override
    public void setBackground(Background background) {
        super.setBackground(background);
        this.map = (short)(this.map | 0x40);
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
        this.map = (short)(this.map | 0x80);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.map = (short)(this.map | 0x100);
    }

    @Override
    public void setExtraObject(int fieldId, Object fieldValue) {
        super.setExtraObject(fieldId, fieldValue);
        this.map = (short)(this.map | 1 << 9 + fieldId);
    }

    void merge(CascadingStyle style) {
        short map = this.map;
        short styleMap = style.map;
        int computedMap = ~map & styleMap;
        if (computedMap != 0) {
            this.merge(style, computedMap);
        }
    }

    private void merge(CascadingStyle style, int mergeMap) {
        if ((mergeMap & 1) != 0) {
            assert (style.getDimension() != null);
            super.setDimension(style.getDimension());
        }
        if ((mergeMap & 2) != 0) {
            super.setHorizontalAlignment(style.getHorizontalAlignment());
        }
        if ((mergeMap & 4) != 0) {
            super.setVerticalAlignment(style.getVerticalAlignment());
        }
        if ((mergeMap & 8) != 0) {
            assert (style.getMargin() != null);
            super.setMargin(style.getMargin());
        }
        if ((mergeMap & 0x10) != 0) {
            assert (style.getBorder() != null);
            super.setBorder(style.getBorder());
        }
        if ((mergeMap & 0x20) != 0) {
            assert (style.getPadding() != null);
            super.setPadding(style.getPadding());
        }
        if ((mergeMap & 0x40) != 0) {
            assert (style.getBackground() != null);
            super.setBackground(style.getBackground());
        }
        if ((mergeMap & 0x80) != 0) {
            super.setColor(style.getColor());
        }
        if ((mergeMap & 0x100) != 0) {
            assert (style.getFont() != null);
            super.setFont(style.getFont());
        }
        if ((mergeMap & 0xFFFFFE00) != 0) {
            int extraFieldsMergeMap = mergeMap >> 9;
            int fieldId = 6;
            while (fieldId >= 0) {
                if ((extraFieldsMergeMap & 1 << fieldId) != 0) {
                    CascadingStyle fieldValue = style.getExtraObject(fieldId, Object.class, this);
                    assert (fieldValue != this);
                    super.setExtraObject(fieldId, fieldValue);
                }
                --fieldId;
            }
        }
        this.map = (short)(this.map | mergeMap);
    }

    void inheritMerge(Style parentStyle) {
        short map = this.map;
        if ((map & 2) == 0) {
            super.setHorizontalAlignment((byte)parentStyle.getHorizontalAlignment());
        }
        if ((map & 0x80) == 0) {
            super.setColor(parentStyle.getColor());
        }
        if ((map & 0x100) == 0) {
            super.setFont(parentStyle.getFont());
        }
        this.map = (short)(this.map | 0x182);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    void updateHashCode() {
        this.hashCode = (short)super.hashCode();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

